/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationStoreHealth;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.BackoffTimeCalculator;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagStore;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionManager.class);
    private final String originEndpoint;
    private List<AppConfigurationReplicaClient> clients;
    private final Map<String, AppConfigurationReplicaClient> autoFailoverClients;
    private String currentReplica;
    private AppConfigurationStoreHealth health;
    private final AppConfigurationReplicaClientsBuilder clientBuilder;
    private final ConfigStore configStore;
    private final ReplicaLookUp replicaLookUp;

    ConnectionManager(AppConfigurationReplicaClientsBuilder clientBuilder, ConfigStore configStore, ReplicaLookUp replicaLookUp) {
        this.clientBuilder = clientBuilder;
        this.configStore = configStore;
        this.originEndpoint = configStore.getEndpoint();
        this.health = AppConfigurationStoreHealth.NOT_LOADED;
        this.currentReplica = configStore.getEndpoint();
        this.autoFailoverClients = new HashMap<String, AppConfigurationReplicaClient>();
        this.replicaLookUp = replicaLookUp;
    }

    AppConfigurationStoreHealth getHealth() {
        return this.health;
    }

    void setCurrentClient(String replicaEndpoint) {
        this.currentReplica = replicaEndpoint;
    }

    String getMainEndpoint() {
        return this.originEndpoint;
    }

    List<AppConfigurationReplicaClient> getAvailableClients() {
        return this.getAvailableClients(false);
    }

    List<AppConfigurationReplicaClient> getAvailableClients(Boolean useCurrent) {
        List<String> autoFailoverEndpoints;
        boolean foundCurrent;
        if (this.clients == null) {
            this.clients = this.clientBuilder.buildClients(this.configStore);
            if (this.clients.isEmpty()) {
                this.health = AppConfigurationStoreHealth.NOT_LOADED;
            }
        }
        ArrayList<AppConfigurationReplicaClient> availableClients = new ArrayList<AppConfigurationReplicaClient>();
        boolean bl = foundCurrent = useCurrent == false;
        if (this.clients.size() == 1) {
            if (this.clients.get(0).getBackoffEndTime().isBefore(Instant.now())) {
                availableClients.add(this.clients.get(0));
            }
        } else if (this.clients.size() > 0) {
            for (AppConfigurationReplicaClient replicaClient : this.clients) {
                if (replicaClient.getEndpoint().equals(this.currentReplica)) {
                    foundCurrent = true;
                }
                if (!foundCurrent || !replicaClient.getBackoffEndTime().isBefore(Instant.now())) continue;
                LOGGER.debug("Using Client: " + replicaClient.getEndpoint());
                availableClients.add(replicaClient);
            }
        }
        if (availableClients.size() == 0 && (autoFailoverEndpoints = this.replicaLookUp.getAutoFailoverEndpoints(this.configStore.getEndpoint())).size() > 0) {
            for (String failoverEndpoint : autoFailoverEndpoints) {
                AppConfigurationReplicaClient client = this.autoFailoverClients.get(failoverEndpoint);
                if (client == null) {
                    client = this.clientBuilder.buildClient(failoverEndpoint, this.configStore);
                    this.autoFailoverClients.put(failoverEndpoint, client);
                }
                if (!client.getBackoffEndTime().isBefore(Instant.now())) continue;
                availableClients.add(client);
                break;
            }
        }
        if (this.clients.size() > 0 && availableClients.size() == 0) {
            this.health = AppConfigurationStoreHealth.DOWN;
        } else if (this.clients.size() > 0) {
            this.health = AppConfigurationStoreHealth.UP;
        }
        return availableClients;
    }

    void backoffClient(String endpoint) {
        for (AppConfigurationReplicaClient client : this.clients) {
            if (!client.getEndpoint().equals(endpoint)) continue;
            int failedAttempt = client.getFailedAttempts();
            long backoffTime = BackoffTimeCalculator.calculateBackoff(failedAttempt);
            client.updateBackoffEndTime(Instant.now().plusNanos(backoffTime));
            return;
        }
        int failedAttempt = this.autoFailoverClients.get(endpoint).getFailedAttempts();
        long backoffTime = BackoffTimeCalculator.calculateBackoff(failedAttempt);
        this.autoFailoverClients.get(endpoint).updateBackoffEndTime(Instant.now().plusNanos(backoffTime));
    }

    void updateSyncToken(String endpoint, String syncToken) {
        this.clients.stream().filter(client -> client.getEndpoint().equals(endpoint)).findFirst().ifPresent(client -> client.updateSyncToken(syncToken));
        this.autoFailoverClients.values().stream().filter(client -> client.getEndpoint().equals(endpoint)).findFirst().ifPresent(client -> client.updateSyncToken(syncToken));
    }

    AppConfigurationStoreMonitoring getMonitoring() {
        return this.configStore.getMonitoring();
    }

    FeatureFlagStore getFeatureFlagStore() {
        return this.configStore.getFeatureFlags();
    }
}

