/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.util.Context;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.ConnectionManager;
import com.azure.spring.cloud.appconfiguration.config.implementation.State;
import com.azure.spring.cloud.appconfiguration.config.implementation.StateHolder;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlagState;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagStore;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AppConfigurationRefreshUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefreshUtil.class);

    RefreshEventData refreshStoresCheck(AppConfigurationReplicaClientFactory clientFactory, Duration refreshInterval, Long defaultMinBackoff, ReplicaLookUp replicaLookUp) {
        RefreshEventData eventData = new RefreshEventData();
        try {
            if (refreshInterval != null && StateHolder.getNextForcedRefresh() != null && Instant.now().isAfter(StateHolder.getNextForcedRefresh())) {
                String eventDataInfo = "Minimum refresh period reached. Refreshing configurations.";
                LOGGER.info(eventDataInfo);
                eventData.setFullMessage(eventDataInfo);
                return eventData;
            }
            block6: for (Map.Entry<String, ConnectionManager> entry : clientFactory.getConnections().entrySet()) {
                String originEndpoint = entry.getKey();
                ConnectionManager connection = entry.getValue();
                clientFactory.setCurrentConfigStoreClient(originEndpoint, originEndpoint);
                AppConfigurationStoreMonitoring monitor = connection.getMonitoring();
                boolean pushRefresh = false;
                AppConfigurationStoreMonitoring.PushNotification notification = monitor.getPushNotification();
                if (notification.getPrimaryToken() != null && StringUtils.hasText((String)notification.getPrimaryToken().getName()) || notification.getSecondaryToken() != null && StringUtils.hasText((String)notification.getPrimaryToken().getName())) {
                    pushRefresh = true;
                }
                Context context = new Context((Object)"refresh", (Object)true).addData((Object)"PushRefresh", (Object)pushRefresh);
                List<AppConfigurationReplicaClient> clients = clientFactory.getAvailableClients(originEndpoint);
                if (monitor.isEnabled() && StateHolder.getLoadState(originEndpoint)) {
                    for (AppConfigurationReplicaClient client : clients) {
                        try {
                            AppConfigurationRefreshUtil.refreshWithTime(client, StateHolder.getState(originEndpoint), monitor.getRefreshInterval(), eventData, replicaLookUp, context);
                            if (eventData.getDoRefresh()) {
                                clientFactory.setCurrentConfigStoreClient(originEndpoint, client.getEndpoint());
                                return eventData;
                            }
                            break;
                        }
                        catch (HttpResponseException e) {
                            LOGGER.warn("Failed to connect to App Configuration store {} during configuration refresh check. Status: {}, Message: {}", new Object[]{client.getEndpoint(), e.getResponse().getStatusCode(), e.getMessage()});
                            clientFactory.backoffClient(originEndpoint, client.getEndpoint());
                        }
                    }
                } else {
                    LOGGER.debug("Skipping configuration refresh check for " + originEndpoint);
                }
                FeatureFlagStore featureStore = connection.getFeatureFlagStore();
                if (featureStore.getEnabled().booleanValue() && StateHolder.getStateFeatureFlag(originEndpoint) != null) {
                    for (AppConfigurationReplicaClient client : clients) {
                        try {
                            AppConfigurationRefreshUtil.refreshWithTimeFeatureFlags(client, StateHolder.getStateFeatureFlag(originEndpoint), monitor.getFeatureFlagRefreshInterval(), eventData, replicaLookUp, context);
                            if (!eventData.getDoRefresh()) continue block6;
                            clientFactory.setCurrentConfigStoreClient(originEndpoint, client.getEndpoint());
                            return eventData;
                        }
                        catch (HttpResponseException e) {
                            LOGGER.warn("Failed to connect to App Configuration store {} during feature flag refresh check. Status: {}, Message: {}", new Object[]{client.getEndpoint(), e.getResponse().getStatusCode(), e.getMessage()});
                            clientFactory.backoffClient(originEndpoint, client.getEndpoint());
                        }
                    }
                    continue;
                }
                LOGGER.debug("Skipping feature flag refresh check for " + originEndpoint);
            }
        }
        catch (Exception e) {
            StateHolder.getCurrentState().updateNextRefreshTime(refreshInterval, defaultMinBackoff);
            throw e;
        }
        return eventData;
    }

    static boolean refreshStoreCheck(AppConfigurationReplicaClient client, String originEndpoint, Context context) {
        RefreshEventData eventData = new RefreshEventData();
        if (StateHolder.getLoadState(originEndpoint)) {
            AppConfigurationRefreshUtil.refreshWithoutTime(client, StateHolder.getState(originEndpoint).getWatchKeys(), eventData, context);
        }
        return eventData.getDoRefresh();
    }

    static boolean refreshStoreFeatureFlagCheck(Boolean featureStoreEnabled, AppConfigurationReplicaClient client, Context context) {
        RefreshEventData eventData = new RefreshEventData();
        String endpoint = client.getEndpoint();
        if (featureStoreEnabled.booleanValue() && StateHolder.getStateFeatureFlag(endpoint) != null) {
            AppConfigurationRefreshUtil.refreshWithoutTimeFeatureFlags(client, StateHolder.getStateFeatureFlag(endpoint), eventData, context);
        } else {
            LOGGER.debug("Skipping feature flag refresh check for " + endpoint);
        }
        return eventData.getDoRefresh();
    }

    private static void refreshWithTime(AppConfigurationReplicaClient client, State state, Duration refreshInterval, RefreshEventData eventData, ReplicaLookUp replicaLookUp, Context context) throws AppConfigurationStatusException {
        if (Instant.now().isAfter(state.getNextRefreshCheck())) {
            replicaLookUp.updateAutoFailoverEndpoints();
            AppConfigurationRefreshUtil.refreshWithoutTime(client, state.getWatchKeys(), eventData, context);
            StateHolder.getCurrentState().updateStateRefresh(state, refreshInterval);
        }
    }

    private static void refreshWithoutTime(AppConfigurationReplicaClient client, List<ConfigurationSetting> watchKeys, RefreshEventData eventData, Context context) throws AppConfigurationStatusException {
        for (ConfigurationSetting watchKey : watchKeys) {
            ConfigurationSetting watchedKey = client.getWatchKey(watchKey.getKey(), watchKey.getLabel(), context);
            if (watchedKey == null) continue;
            AppConfigurationRefreshUtil.checkETag(watchKey, watchedKey, client.getEndpoint(), eventData);
            if (!eventData.getDoRefresh()) continue;
            break;
        }
    }

    private static void refreshWithTimeFeatureFlags(AppConfigurationReplicaClient client, FeatureFlagState state, Duration refreshInterval, RefreshEventData eventData, ReplicaLookUp replicaLookUp, Context context) throws AppConfigurationStatusException {
        Instant date = Instant.now();
        if (date.isAfter(state.getNextRefreshCheck())) {
            replicaLookUp.updateAutoFailoverEndpoints();
            for (FeatureFlags featureFlags : state.getWatchKeys()) {
                if (!client.checkWatchKeys(featureFlags.getSettingSelector(), context)) continue;
                String eventDataInfo = ".appconfig.featureflag/*";
                LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
                eventData.setMessage(eventDataInfo);
                return;
            }
            StateHolder.getCurrentState().updateFeatureFlagStateRefresh(state, refreshInterval);
        }
    }

    private static void refreshWithoutTimeFeatureFlags(AppConfigurationReplicaClient client, FeatureFlagState watchKeys, RefreshEventData eventData, Context context) throws AppConfigurationStatusException {
        for (FeatureFlags featureFlags : watchKeys.getWatchKeys()) {
            if (!client.checkWatchKeys(featureFlags.getSettingSelector(), context)) continue;
            String eventDataInfo = ".appconfig.featureflag/*";
            LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
            eventData.setMessage(eventDataInfo);
        }
    }

    private static void checkETag(ConfigurationSetting watchSetting, ConfigurationSetting currentTriggerConfiguration, String endpoint, RefreshEventData eventData) {
        if (currentTriggerConfiguration == null) {
            return;
        }
        LOGGER.debug("Comparing eTags - watched: {} vs current: {}", (Object)watchSetting.getETag(), (Object)currentTriggerConfiguration.getETag());
        if (watchSetting.getETag() != null && !watchSetting.getETag().equals(currentTriggerConfiguration.getETag())) {
            LOGGER.trace("Some keys in store [{}] matching the key [{}] and label [{}] is updated, will send refresh event.", new Object[]{endpoint, watchSetting.getKey(), watchSetting.getLabel()});
            String eventDataInfo = watchSetting.getKey();
            LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
            eventData.setMessage(eventDataInfo);
        }
    }

    static class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private String message = "";
        private boolean doRefresh = false;

        RefreshEventData() {
        }

        RefreshEventData setMessage(String prefix) {
            this.setFullMessage(String.format(MSG_TEMPLATE, prefix));
            return this;
        }

        private RefreshEventData setFullMessage(String message) {
            this.message = message;
            this.doRefresh = true;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getDoRefresh() {
            return this.doRefresh;
        }
    }
}

