/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationRefresh;
import com.azure.spring.cloud.appconfiguration.config.AppConfigurationStoreHealth;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationRefreshUtil;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.StateHolder;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class AppConfigurationPullRefresh
implements AppConfigurationRefresh {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPullRefresh.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private final Long defaultMinBackoff = 30L;
    private static final Long DEFAULT_MIN_BACKOFF_SECONDS = 30L;
    private final AppConfigurationReplicaClientFactory clientFactory;
    private final Duration refreshInterval;
    private final ReplicaLookUp replicaLookUp;
    private final AppConfigurationRefreshUtil refreshUtils;

    public AppConfigurationPullRefresh(AppConfigurationReplicaClientFactory clientFactory, Duration refreshInterval, ReplicaLookUp replicaLookUp, AppConfigurationRefreshUtil refreshUtils) {
        this.refreshInterval = refreshInterval;
        this.clientFactory = clientFactory;
        this.replicaLookUp = replicaLookUp;
        this.refreshUtils = refreshUtils;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @Override
    public Mono<Boolean> refreshConfigurations() {
        return Mono.just((Object)this.refreshStores());
    }

    @Override
    public void expireRefreshInterval(String endpoint, String syncToken) {
        LOGGER.debug("Expiring refresh interval for " + endpoint);
        String originEndpoint = this.clientFactory.findOriginForEndpoint(endpoint);
        this.clientFactory.updateSyncToken(originEndpoint, endpoint, syncToken);
        StateHolder.getCurrentState().expireState(originEndpoint);
    }

    private boolean refreshStores() {
        if (this.running.compareAndSet(false, true)) {
            try {
                AppConfigurationRefreshUtil.RefreshEventData eventData = this.refreshUtils.refreshStoresCheck(this.clientFactory, this.refreshInterval, DEFAULT_MIN_BACKOFF_SECONDS, this.replicaLookUp);
                if (eventData.getDoRefresh()) {
                    this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred during configuration refresh, will retry at next interval", (Throwable)e);
                StateHolder.getCurrentState().updateNextRefreshTime(this.refreshInterval, DEFAULT_MIN_BACKOFF_SECONDS);
                throw e;
            }
            finally {
                this.running.set(false);
            }
        }
        return false;
    }

    @Override
    public Map<String, AppConfigurationStoreHealth> getAppConfigurationStoresHealth() {
        return this.clientFactory.getHealth();
    }
}

