/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.config;

import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.spring.cloud.appconfiguration.config.ConfigurationClientCustomizer;
import com.azure.spring.cloud.appconfiguration.config.KeyVaultSecretProvider;
import com.azure.spring.cloud.appconfiguration.config.SecretClientCustomizer;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySourceLocator;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientsBuilder;
import com.azure.spring.cloud.appconfiguration.config.implementation.FeatureFlagClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProperties;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.autoconfigure.implementation.appconfiguration.AzureAppConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.context.properties.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.properties.AzureKeyVaultSecretProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.AbstractAzureHttpConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.authentication.TokenCredentialConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureGlobalPropertiesUtils;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzurePropertiesUtils;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.service.implementation.appconfiguration.ConfigurationClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.appconfiguration.ConfigurationClientProperties;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientProperties;
import javax.naming.NamingException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.util.StringUtils;

@Configuration
@PropertySource(value={"classpath:appConfiguration.properties"})
@EnableConfigurationProperties(value={AppConfigurationProperties.class, AppConfigurationProviderProperties.class})
@ConditionalOnClass(value={AppConfigurationPropertySourceLocator.class})
@ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"enabled"}, matchIfMissing=true)
@EnableAsync
public class AppConfigurationBootstrapConfiguration {
    @Autowired
    private transient ApplicationContext context;

    @Bean
    AppConfigurationPropertySourceLocator sourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, AppConfigurationReplicaClientFactory clientFactory, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, ReplicaLookUp replicaLookUp, FeatureFlagClient featureFlagLoader) throws IllegalArgumentException {
        return new AppConfigurationPropertySourceLocator(appProperties, clientFactory, keyVaultClientFactory, properties.getRefreshInterval(), properties.getStores(), replicaLookUp, featureFlagLoader);
    }

    @Bean
    AppConfigurationKeyVaultClientFactory appConfigurationKeyVaultClientFactory(Environment environment, AppConfigurationProviderProperties appProperties) throws IllegalArgumentException {
        AzureGlobalProperties globalSource = (AzureGlobalProperties)Binder.get((Environment)environment).bindOrCreate("spring.cloud.azure", AzureGlobalProperties.class);
        AzureGlobalProperties serviceSource = (AzureGlobalProperties)Binder.get((Environment)environment).bindOrCreate("spring.cloud.azure.keyvault.secret", AzureGlobalProperties.class);
        AzureKeyVaultSecretProperties globalProperties = (AzureKeyVaultSecretProperties)AzureGlobalPropertiesUtils.loadProperties((AzureGlobalProperties)globalSource, (AzureProperties)new AzureKeyVaultSecretProperties());
        AzureKeyVaultSecretProperties clientProperties = (AzureKeyVaultSecretProperties)AzureGlobalPropertiesUtils.loadProperties((AzureGlobalProperties)serviceSource, (AzureProperties)new AzureKeyVaultSecretProperties());
        AzurePropertiesUtils.copyAzureCommonPropertiesIgnoreNull((AzureProperties)globalProperties, (AzureProperties)clientProperties);
        SecretClientCustomizer keyVaultClientProvider = (SecretClientCustomizer)this.context.getBeanProvider(SecretClientCustomizer.class).getIfAvailable();
        KeyVaultSecretProvider keyVaultSecretProvider = (KeyVaultSecretProvider)this.context.getBeanProvider(KeyVaultSecretProvider.class).getIfAvailable();
        SecretClientBuilderFactory secretClientBuilderFactory = new SecretClientBuilderFactory((SecretClientProperties)clientProperties);
        boolean credentialConfigured = this.isCredentialConfigured((AbstractAzureHttpConfigurationProperties)clientProperties);
        return new AppConfigurationKeyVaultClientFactory(keyVaultClientProvider, keyVaultSecretProvider, secretClientBuilderFactory, credentialConfigured, appProperties.getMaxRetryTime());
    }

    @Bean
    @ConditionalOnMissingBean
    AppConfigurationReplicaClientFactory buildClientFactory(AppConfigurationReplicaClientsBuilder clientBuilder, AppConfigurationProperties properties, ReplicaLookUp replicaLookUp) {
        return new AppConfigurationReplicaClientFactory(clientBuilder, properties.getStores(), replicaLookUp);
    }

    @Bean
    @ConditionalOnMissingBean
    FeatureFlagClient featureFlagLoader() {
        return new FeatureFlagClient();
    }

    @Bean
    @ConditionalOnMissingBean
    AppConfigurationReplicaClientsBuilder replicaClientBuilder(Environment environment, AppConfigurationProviderProperties appProperties, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, ObjectProvider<AzureServiceClientBuilderCustomizer<ConfigurationClientBuilder>> customizers) {
        AzureGlobalProperties globalSource = (AzureGlobalProperties)Binder.get((Environment)environment).bindOrCreate("spring.cloud.azure", AzureGlobalProperties.class);
        AzureGlobalProperties serviceSource = (AzureGlobalProperties)Binder.get((Environment)environment).bindOrCreate("spring.cloud.azure.appconfiguration", AzureGlobalProperties.class);
        AzureGlobalProperties globalProperties = (AzureGlobalProperties)AzureGlobalPropertiesUtils.loadProperties((AzureGlobalProperties)globalSource, (AzureProperties)new AzureGlobalProperties());
        AzureAppConfigurationProperties clientProperties = (AzureAppConfigurationProperties)AzureGlobalPropertiesUtils.loadProperties((AzureGlobalProperties)serviceSource, (AzureProperties)new AzureAppConfigurationProperties());
        AzurePropertiesUtils.copyAzureCommonPropertiesIgnoreNull((AzureProperties)globalProperties, (AzureProperties)clientProperties);
        ConfigurationClientBuilderFactory clientFactory = new ConfigurationClientBuilderFactory((ConfigurationClientProperties)clientProperties);
        clientFactory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_APP_CONFIG);
        customizers.orderedStream().forEach(arg_0 -> ((ConfigurationClientBuilderFactory)clientFactory).addBuilderCustomizer(arg_0));
        boolean credentialConfigured = this.isCredentialConfigured((AbstractAzureHttpConfigurationProperties)clientProperties);
        AppConfigurationReplicaClientsBuilder clientBuilder = new AppConfigurationReplicaClientsBuilder(appProperties.getMaxRetries(), clientFactory, credentialConfigured);
        clientBuilder.setClientProvider((ConfigurationClientCustomizer)this.context.getBeanProvider(ConfigurationClientCustomizer.class).getIfAvailable());
        clientBuilder.setIsKeyVaultConfigured(keyVaultClientFactory.isConfigured());
        return clientBuilder;
    }

    @Bean
    ReplicaLookUp replicaLookUp(AppConfigurationProperties properties) throws NamingException {
        return new ReplicaLookUp(properties);
    }

    private boolean isCredentialConfigured(AbstractAzureHttpConfigurationProperties properties) {
        if (properties.getCredential() != null) {
            TokenCredentialConfigurationProperties tokenProps = properties.getCredential();
            if (StringUtils.hasText((String)tokenProps.getClientCertificatePassword())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getClientCertificatePath())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getClientId())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getClientSecret())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getUsername())) {
                return true;
            }
            if (StringUtils.hasText((String)tokenProps.getPassword())) {
                return true;
            }
        }
        return false;
    }
}

