/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.Feature;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.entity.FeatureTelemetry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.nimbusds.jose.util.Base64URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FeatureFlagClient {
    protected final Map<String, Feature> properties = new LinkedHashMap<String, Feature>();
    private static final ObjectMapper CASE_INSENSITIVE_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();

    public List<FeatureFlags> loadFeatureFlags(AppConfigurationReplicaClient replicaClient, String customKeyFilter, String[] labelFilter, boolean isRefresh) {
        ArrayList<FeatureFlags> loadedFeatureFlags = new ArrayList<FeatureFlags>();
        Object keyFilter = ".appconfig.featureflag/*";
        if (StringUtils.hasText((String)customKeyFilter)) {
            keyFilter = ".appconfig.featureflag/" + customKeyFilter;
        }
        List<String> labels = Arrays.asList(labelFilter);
        Collections.reverse(labels);
        for (String label : labels) {
            SettingSelector settingSelector = new SettingSelector().setKeyFilter((String)keyFilter).setLabelFilter(label);
            FeatureFlags features = replicaClient.listFeatureFlags(settingSelector, isRefresh);
            loadedFeatureFlags.addAll(this.proccessFeatureFlags(features, (String)keyFilter));
        }
        return loadedFeatureFlags;
    }

    public List<FeatureFlags> proccessFeatureFlags(FeatureFlags features, String endpoint) {
        ArrayList<FeatureFlags> loadedFeatureFlags = new ArrayList<FeatureFlags>();
        loadedFeatureFlags.add(features);
        for (ConfigurationSetting setting : features.getFeatureFlags()) {
            if (!(setting instanceof FeatureFlagConfigurationSetting) || !"application/vnd.microsoft.appconfig.ff+json;charset=utf-8".equals(setting.getContentType())) continue;
            FeatureFlagConfigurationSetting featureFlag = (FeatureFlagConfigurationSetting)setting;
            this.properties.put(featureFlag.getKey(), FeatureFlagClient.createFeature(featureFlag, endpoint));
        }
        return loadedFeatureFlags;
    }

    protected static Feature createFeature(FeatureFlagConfigurationSetting item, String originEndpoint) {
        FeatureTelemetry telemetry;
        String requirementType = "Any";
        FeatureTelemetry featureTelemetry = new FeatureTelemetry();
        try {
            JsonNode telemetryNode;
            JsonNode node = CASE_INSENSITIVE_MAPPER.readTree(item.getValue());
            JsonNode conditions = node.get("conditions");
            if (conditions != null && conditions.get("requirement_type") != null) {
                requirementType = conditions.get("requirement_type").asText();
            }
            if ((telemetryNode = node.get("telemetry")) != null) {
                ObjectMapper objectMapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
                featureTelemetry = (FeatureTelemetry)objectMapper.convertValue((Object)telemetryNode, FeatureTelemetry.class);
            }
        }
        catch (JsonProcessingException node) {
            // empty catch block
        }
        Feature feature = new Feature(item, requirementType, featureTelemetry);
        if (feature.getTelemetry() != null && (telemetry = feature.getTelemetry()).isEnabled()) {
            Map<String, String> originMetadata = telemetry.getMetadata();
            originMetadata.put("FeatureFlagId", FeatureFlagClient.calculateFeatureFlagId(item.getKey(), item.getLabel()));
            originMetadata.put("ETag", item.getETag());
            if (originEndpoint != null && !originEndpoint.isEmpty()) {
                String labelPart = item.getLabel().isEmpty() ? "" : String.format("?label=%s", item.getLabel());
                originMetadata.put("FeatureFlagReference", String.format("%s/kv/%s%s", originEndpoint, item.getKey(), labelPart));
            }
        }
        return feature;
    }

    private static String calculateFeatureFlagId(String key, String label) {
        String data = String.format("%s\n%s", key, label.isEmpty() ? null : label);
        SHA256.Digest digest = new SHA256.Digest();
        String beforeTrim = Base64URL.encode((byte[])digest.digest(data.getBytes(StandardCharsets.UTF_8))).toString().replace('+', '-').replace('/', '_');
        int index = beforeTrim.indexOf(61);
        return beforeTrim.substring(0, index > -1 ? index : beforeTrim.length());
    }

    public Map<String, Feature> getProperties() {
        return this.properties;
    }
}

