/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationApplicationSettingPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationFeatureManagementPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationRefreshUtil;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationSnapshotPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.BackoffTimeCalculator;
import com.azure.spring.cloud.appconfiguration.config.implementation.FeatureFlagClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.StateHolder;
import com.azure.spring.cloud.appconfiguration.config.implementation.autofailover.ReplicaLookUp;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationKeyValueSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationProviderProperties;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagKeyValueSelector;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public final class AppConfigurationPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySourceLocator.class);
    private static final String PROPERTY_SOURCE_NAME = "azure-config-store";
    private static final String REFRESH_ARGS_PROPERTY_SOURCE = "refreshArgs";
    private final List<ConfigStore> configStores;
    private final AppConfigurationProviderProperties appProperties;
    private final AppConfigurationReplicaClientFactory clientFactory;
    private final AppConfigurationKeyVaultClientFactory keyVaultClientFactory;
    private final FeatureFlagClient featureFlagClient;
    private final ReplicaLookUp replicaLookUp;
    private Duration refreshInterval;
    static final AtomicBoolean STARTUP = new AtomicBoolean(true);

    public AppConfigurationPropertySourceLocator(AppConfigurationProviderProperties appProperties, AppConfigurationReplicaClientFactory clientFactory, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, Duration refreshInterval, List<ConfigStore> configStores, ReplicaLookUp replicaLookUp, FeatureFlagClient featureFlagLoader) {
        this.refreshInterval = refreshInterval;
        this.appProperties = appProperties;
        this.configStores = configStores;
        this.clientFactory = clientFactory;
        this.keyVaultClientFactory = keyVaultClientFactory;
        this.replicaLookUp = replicaLookUp;
        this.featureFlagClient = featureFlagLoader;
        BackoffTimeCalculator.setDefaults(appProperties.getDefaultMaxBackoff(), appProperties.getDefaultMinBackoff());
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        this.replicaLookUp.updateAutoFailoverEndpoints();
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        boolean currentlyLoaded = env.getPropertySources().stream().anyMatch(source -> {
            String storeName = this.configStores.get(0).getEndpoint();
            if (this.configStores.get(0).getSelects().size() == 0) {
                return false;
            }
            AppConfigurationKeyValueSelector selectedKey = this.configStores.get(0).getSelects().get(0);
            return source.getName().startsWith("bootstrapProperties-" + selectedKey.getKeyFilter() + storeName + "/");
        });
        if (currentlyLoaded && !env.getPropertySources().contains(REFRESH_ARGS_PROPERTY_SOURCE)) {
            return null;
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        CompositePropertySource composite = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        Collections.reverse(this.configStores);
        StateHolder newState = new StateHolder();
        newState.setNextForcedRefresh(this.refreshInterval);
        for (ConfigStore configStore : this.configStores) {
            boolean loadNewPropertySources;
            boolean bl = loadNewPropertySources = STARTUP.get() || StateHolder.getLoadState(configStore.getEndpoint());
            if (configStore.isEnabled() && loadNewPropertySources) {
                List<AppConfigurationReplicaClient> clients = this.clientFactory.getAvailableClients(configStore.getEndpoint(), true);
                boolean generatedPropertySources = false;
                ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
                boolean reloadFailed = false;
                for (AppConfigurationReplicaClient client : clients) {
                    sourceList = new ArrayList();
                    if (!STARTUP.get() && reloadFailed && !AppConfigurationRefreshUtil.checkStoreAfterRefreshFailed(client, this.clientFactory, configStore.getFeatureFlags())) continue;
                    try {
                        List<AppConfigurationPropertySource> sources = this.createSettings(client, configStore, profiles);
                        List<FeatureFlags> featureFlags = this.createFeatureFlags(client, configStore, profiles);
                        sourceList.addAll(sources);
                        LOGGER.debug("PropertySource context.");
                        this.setupMonitoring(configStore, client, sources, newState, featureFlags);
                        generatedPropertySources = true;
                    }
                    catch (AppConfigurationStatusException e) {
                        reloadFailed = true;
                        this.clientFactory.backoffClientClient(configStore.getEndpoint(), client.getEndpoint());
                    }
                    catch (Exception e) {
                        newState = this.failedToGeneratePropertySource(configStore, newState, e);
                        break;
                    }
                    if (!generatedPropertySources) continue;
                    break;
                }
                if (generatedPropertySources) {
                    sourceList.forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
                } else if (!STARTUP.get() || configStore.isFailFast() && STARTUP.get()) {
                    String message = "Failed to generate property sources for " + configStore.getEndpoint();
                    this.failedToGeneratePropertySource(configStore, newState, new RuntimeException(message));
                }
                if (this.featureFlagClient.getProperties().size() <= 0) continue;
                AppConfigurationFeatureManagementPropertySource acfmps = new AppConfigurationFeatureManagementPropertySource(this.featureFlagClient);
                composite.addPropertySource((PropertySource)acfmps);
                continue;
            }
            if (!configStore.isEnabled() && loadNewPropertySources) {
                LOGGER.info("Not loading configurations from {} as it is not enabled.", (Object)configStore.getEndpoint());
                continue;
            }
            LOGGER.warn("Not loading configurations from {} as it failed on startup.", (Object)configStore.getEndpoint());
        }
        StateHolder.updateState(newState);
        STARTUP.set(false);
        return composite;
    }

    private void setupMonitoring(ConfigStore configStore, AppConfigurationReplicaClient client, List<AppConfigurationPropertySource> sources, StateHolder newState, List<FeatureFlags> featureFlags) {
        AppConfigurationStoreMonitoring monitoring = configStore.getMonitoring();
        if (configStore.getFeatureFlags().getEnabled().booleanValue()) {
            newState.setStateFeatureFlag(configStore.getEndpoint(), featureFlags, monitoring.getFeatureFlagRefreshInterval());
        }
        if (monitoring.isEnabled()) {
            List<ConfigurationSetting> watchKeysSettings = monitoring.getTriggers().stream().map(trigger -> client.getWatchKey(trigger.getKey(), trigger.getLabel(), !STARTUP.get())).toList();
            newState.setState(configStore.getEndpoint(), watchKeysSettings, monitoring.getRefreshInterval());
        }
        newState.setLoadState(configStore.getEndpoint(), true, configStore.isFailFast());
    }

    private StateHolder failedToGeneratePropertySource(ConfigStore configStore, StateHolder newState, Exception e) {
        String message = "Failed to generate property sources for " + configStore.getEndpoint();
        if (!STARTUP.get()) {
            LOGGER.error("Refreshing failed while reading configuration from Azure App Configuration store " + configStore.getEndpoint() + ".");
            if (this.refreshInterval != null) {
                newState.updateNextRefreshTime(this.refreshInterval, this.appProperties.getDefaultMinBackoff());
            }
            throw new RuntimeException(message, e);
        }
        if (configStore.isFailFast()) {
            LOGGER.error("Fail fast is set and there was an error reading configuration from Azure App Configuration store " + configStore.getEndpoint() + ".");
            this.delayException();
            throw new RuntimeException(message, e);
        }
        LOGGER.warn("Unable to load configuration from Azure AppConfiguration store " + configStore.getEndpoint() + ".", (Throwable)e);
        newState.setLoadState(configStore.getEndpoint(), false, configStore.isFailFast());
        return newState;
    }

    private List<AppConfigurationPropertySource> createSettings(AppConfigurationReplicaClient client, ConfigStore store, List<String> profiles) throws Exception {
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        List<AppConfigurationKeyValueSelector> selects = store.getSelects();
        for (AppConfigurationKeyValueSelector selectedKeys : selects) {
            AppConfigurationApplicationSettingPropertySource propertySource = null;
            propertySource = StringUtils.hasText((String)selectedKeys.getSnapshotName()) ? new AppConfigurationSnapshotPropertySource(selectedKeys.getSnapshotName() + "/" + store.getEndpoint(), client, this.keyVaultClientFactory, selectedKeys.getSnapshotName(), this.featureFlagClient) : new AppConfigurationApplicationSettingPropertySource(selectedKeys.getKeyFilter() + store.getEndpoint() + "/", client, this.keyVaultClientFactory, selectedKeys.getKeyFilter(), selectedKeys.getLabelFilter(profiles));
            ((AppConfigurationPropertySource)propertySource).initProperties(store.getTrimKeyPrefix(), !STARTUP.get());
            sourceList.add(propertySource);
        }
        return sourceList;
    }

    private List<FeatureFlags> createFeatureFlags(AppConfigurationReplicaClient client, ConfigStore store, List<String> profiles) throws Exception {
        ArrayList<FeatureFlags> featureFlagWatchKeys = new ArrayList<FeatureFlags>();
        if (store.getFeatureFlags().getEnabled().booleanValue()) {
            for (FeatureFlagKeyValueSelector selectedKeys : store.getFeatureFlags().getSelects()) {
                List<FeatureFlags> storesFeatureFlags = this.featureFlagClient.loadFeatureFlags(client, selectedKeys.getKeyFilter(), selectedKeys.getLabelFilter(profiles), !STARTUP.get());
                storesFeatureFlags.forEach(featureFlags -> featureFlags.setConfigStore(store));
                featureFlagWatchKeys.addAll(storesFeatureFlags);
            }
        }
        return featureFlagWatchKeys;
    }

    private void delayException() {
        Instant preKillTIme;
        Instant currentDate = Instant.now();
        if (currentDate.isBefore(preKillTIme = this.appProperties.getStartDate().plusSeconds(this.appProperties.getPrekillTime()))) {
            long diffInMillies = Math.abs(preKillTIme.toEpochMilli() - currentDate.toEpochMilli());
            try {
                Thread.sleep(diffInMillies);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to wait before fast fail.");
            }
        }
    }
}

