/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.BackoffTimeCalculator;
import com.azure.spring.cloud.appconfiguration.config.implementation.State;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlagState;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class StateHolder {
    private static final int MAX_JITTER = 15;
    private static StateHolder currentState;
    private final Map<String, State> state = new ConcurrentHashMap<String, State>();
    private final Map<String, FeatureFlagState> featureFlagState = new ConcurrentHashMap<String, FeatureFlagState>();
    private final Map<String, Boolean> loadState = new ConcurrentHashMap<String, Boolean>();
    private Integer clientRefreshAttempts = 1;
    private Instant nextForcedRefresh;

    StateHolder() {
    }

    static StateHolder getCurrentState() {
        return currentState;
    }

    static StateHolder updateState(StateHolder newState) {
        currentState = newState;
        return currentState;
    }

    static State getState(String originEndpoint) {
        return currentState.getFullState().get(originEndpoint);
    }

    private Map<String, State> getFullState() {
        return this.state;
    }

    private Map<String, FeatureFlagState> getFullFeatureFlagState() {
        return this.featureFlagState;
    }

    private Map<String, Boolean> getFullLoadState() {
        return this.loadState;
    }

    static FeatureFlagState getStateFeatureFlag(String originEndpoint) {
        return currentState.getFullFeatureFlagState().get(originEndpoint);
    }

    void setState(String originEndpoint, List<ConfigurationSetting> watchKeys, Duration duration) {
        this.state.put(originEndpoint, new State(watchKeys, Math.toIntExact(duration.getSeconds()), originEndpoint));
    }

    void setStateFeatureFlag(String originEndpoint, List<FeatureFlags> watchKeys, Duration duration) {
        this.featureFlagState.put(originEndpoint, new FeatureFlagState(watchKeys, Math.toIntExact(duration.getSeconds()), originEndpoint));
    }

    void setState(State state, Duration duration) {
        this.state.put(state.getOriginEndpoint(), new State(state, Instant.now().plusSeconds(Math.toIntExact(duration.getSeconds()))));
    }

    void updateStateRefresh(State state, Duration duration) {
        this.state.put(state.getOriginEndpoint(), new State(state, Instant.now().plusSeconds(Math.toIntExact(duration.getSeconds()))));
    }

    void updateFeatureFlagStateRefresh(FeatureFlagState state, Duration duration) {
        this.featureFlagState.put(state.getOriginEndpoint(), new FeatureFlagState(state, Instant.now().plusSeconds(Math.toIntExact(duration.getSeconds()))));
    }

    void expireState(String originEndpoint) {
        long timeLeft;
        State oldState = this.state.get(originEndpoint);
        long wait = (long)(new SecureRandom().nextDouble() * 15.0);
        if (wait < (timeLeft = (long)((int)((oldState.getNextRefreshCheck().toEpochMilli() - Instant.now().toEpochMilli()) / 1000L)))) {
            this.state.put(originEndpoint, new State(oldState, Instant.now().plusSeconds(wait)));
        }
    }

    static boolean getLoadState(String originEndpoint) {
        return currentState.getFullLoadState().getOrDefault(originEndpoint, false);
    }

    Map<String, Boolean> getLoadState() {
        return this.loadState;
    }

    void setLoadState(String originEndpoint, Boolean loaded, Boolean failFast) {
        if (loaded.booleanValue() || !failFast.booleanValue()) {
            this.loadState.put(originEndpoint, true);
        } else {
            this.loadState.put(originEndpoint, false);
        }
    }

    public static Instant getNextForcedRefresh() {
        return StateHolder.currentState.nextForcedRefresh;
    }

    public void setNextForcedRefresh(Duration refreshPeriod) {
        if (refreshPeriod != null) {
            this.nextForcedRefresh = Instant.now().plusSeconds(refreshPeriod.getSeconds());
        }
    }

    void updateNextRefreshTime(Duration refreshInterval, Long defaultMinBackoff) {
        if (refreshInterval != null) {
            Instant newForcedRefresh = this.getNextRefreshCheck(this.nextForcedRefresh, this.clientRefreshAttempts, refreshInterval.getSeconds(), defaultMinBackoff);
            if (newForcedRefresh.compareTo(this.nextForcedRefresh) != 0) {
                this.clientRefreshAttempts = this.clientRefreshAttempts + 1;
            }
            this.nextForcedRefresh = newForcedRefresh;
        }
        for (Map.Entry<String, State> entry : this.state.entrySet()) {
            State state = entry.getValue();
            Instant newRefresh = this.getNextRefreshCheck(state.getNextRefreshCheck(), state.getRefreshAttempt(), Long.valueOf(state.getRefreshInterval()), defaultMinBackoff);
            if (newRefresh.compareTo(entry.getValue().getNextRefreshCheck()) != 0) {
                state.incrementRefreshAttempt();
            }
            State updatedState = new State(state, newRefresh);
            this.state.put(entry.getKey(), updatedState);
        }
    }

    private Instant getNextRefreshCheck(Instant nextRefreshCheck, Integer attempt, Long interval, Long defaultMinBackoff) {
        if (!Instant.now().isAfter(nextRefreshCheck)) {
            return nextRefreshCheck;
        }
        int durationPeriod = Math.toIntExact(interval);
        Instant now = Instant.now();
        if ((long)durationPeriod <= defaultMinBackoff) {
            return now.plusSeconds(interval);
        }
        return now.plusNanos(BackoffTimeCalculator.calculateBackoff(attempt));
    }
}

