/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import java.util.Random;

final class BackoffTimeCalculator {
    private static final Long MAX_ATTEMPTS = 63L;
    private static final Long SECONDS_TO_NANO_SECONDS = 1000000000L;
    private static final Random RANDOM = new Random();
    private static Long maxBackoff = 600L;
    private static Long minBackoff = 30L;

    BackoffTimeCalculator() {
    }

    static void setDefaults(Long maxBackoff, Long minBackoff) {
        BackoffTimeCalculator.maxBackoff = maxBackoff;
        BackoffTimeCalculator.minBackoff = minBackoff;
    }

    static Long calculateBackoff(Integer attempts) {
        if (minBackoff < 0L) {
            throw new IllegalArgumentException("Minimum Backoff time needs to be greater than or equal to 0.");
        }
        if (maxBackoff < 0L) {
            throw new IllegalArgumentException("Maximum Backoff time needs to be greater than or equal to 0.");
        }
        if (attempts < 0) {
            throw new IllegalArgumentException("Number of previous attempts needs to be a positive number.");
        }
        long minBackoffNano = minBackoff * SECONDS_TO_NANO_SECONDS;
        long maxBackoffNano = maxBackoff * SECONDS_TO_NANO_SECONDS;
        if (attempts <= 1 || maxBackoff <= minBackoff) {
            return minBackoffNano;
        }
        double maxNanoSeconds = Math.max(1L, minBackoffNano) * (1L << (int)Math.min((long)attempts.intValue(), MAX_ATTEMPTS));
        if (maxNanoSeconds > (double)maxBackoffNano || maxNanoSeconds <= 0.0) {
            maxNanoSeconds = maxBackoffNano;
        }
        return (long)((double)minBackoffNano + (RANDOM.nextDouble() * (maxNanoSeconds - (double)minBackoffNano) + (double)minBackoffNano));
    }
}

