/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.implementation.appconfiguration;

import com.azure.spring.cloud.appconfiguration.config.AppConfigurationRefresh;
import com.azure.spring.cloud.appconfiguration.config.AppConfigurationStoreHealth;
import org.springframework.boot.health.contributor.AbstractHealthIndicator;
import org.springframework.boot.health.contributor.Health;

public class AppConfigurationConfigHealthIndicator
extends AbstractHealthIndicator {
    private final AppConfigurationRefresh refresh;

    public AppConfigurationConfigHealthIndicator(AppConfigurationRefresh refresh) {
        this.refresh = refresh;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        boolean healthy = true;
        for (String store : this.refresh.getAppConfigurationStoresHealth().keySet()) {
            if (AppConfigurationStoreHealth.DOWN.equals(this.refresh.getAppConfigurationStoresHealth().get(store))) {
                healthy = false;
                builder.withDetail(store, (Object)"DOWN");
                continue;
            }
            if (AppConfigurationStoreHealth.NOT_LOADED.equals(this.refresh.getAppConfigurationStoresHealth().get(store))) {
                builder.withDetail(store, (Object)"NOT LOADED");
                continue;
            }
            builder.withDetail(store, (Object)"UP");
        }
        if (!healthy) {
            builder.down();
        }
        builder.up();
    }
}

