/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.autoconfigure.implementation.keyvault;

import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.spring.cloud.actuator.implementation.keyvault.KeyVaultSecretHealthIndicator;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.AzureKeyVaultSecretAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SecretAsyncClient.class, HealthIndicator.class})
@ConditionalOnBean(value={SecretAsyncClient.class})
@AutoConfigureAfter(value={AzureKeyVaultSecretAutoConfiguration.class})
@ConditionalOnEnabledHealthIndicator(value="azure-keyvault-secret")
public class KeyVaultSecretHealthConfiguration {
    @Bean
    KeyVaultSecretHealthIndicator keyVaultSecretHealthIndicator(SecretAsyncClient secretAsyncClient) {
        return new KeyVaultSecretHealthIndicator(secretAsyncClient);
    }
}

