/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.feature.manager;

import com.azure.spring.cloud.feature.manager.FeatureManager;
import java.util.HashMap;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Mono;

@Configuration
public class FeatureManagerSnapshot {
    private FeatureManager featureManager;
    private HashMap<String, Boolean> requestMap;

    public FeatureManagerSnapshot(FeatureManager featureManager) {
        this.featureManager = featureManager;
        this.requestMap = new HashMap();
    }

    public Mono<Boolean> isEnabledAsync(String feature) {
        if (this.requestMap.get(feature) != null) {
            return Mono.just((Object)this.requestMap.get(feature));
        }
        return this.featureManager.isEnabledAsync(feature).doOnSuccess(enabled -> this.requestMap.put(feature, (Boolean)enabled));
    }
}

