/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;

public class ServiceBusNamespaceManager
extends AzureManager<ServiceBusNamespace, String> {
    private final AzureResourceManager azureResourceManager;

    public ServiceBusNamespaceManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        super(azureProperties);
        this.azureResourceManager = azureResourceManager;
    }

    @Override
    String getResourceName(String key) {
        return key;
    }

    @Override
    String getResourceType() {
        return ServiceBusNamespace.class.getSimpleName();
    }

    @Override
    public ServiceBusNamespace internalGet(String namespace) {
        try {
            return (ServiceBusNamespace)this.azureResourceManager.serviceBusNamespaces().getByResourceGroup(this.resourceGroup, namespace);
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public ServiceBusNamespace internalCreate(String namespace) {
        return (ServiceBusNamespace)((ServiceBusNamespace.DefinitionStages.WithCreate)((ServiceBusNamespace.DefinitionStages.WithGroup)((ServiceBusNamespace.DefinitionStages.Blank)this.azureResourceManager.serviceBusNamespaces().define(namespace)).withRegion(this.region)).withExistingResourceGroup(this.resourceGroup)).create();
    }
}

