/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.context.core.impl;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.eventhubs.models.EventHub;
import com.azure.resourcemanager.eventhubs.models.EventHubConsumerGroup;
import com.azure.spring.cloud.context.core.config.AzureProperties;
import com.azure.spring.cloud.context.core.impl.AzureManager;
import com.azure.spring.cloud.context.core.util.Tuple;

public class EventHubConsumerGroupManager
extends AzureManager<EventHubConsumerGroup, Tuple<EventHub, String>> {
    private final AzureResourceManager azureResourceManager;

    public EventHubConsumerGroupManager(AzureResourceManager azureResourceManager, AzureProperties azureProperties) {
        super(azureProperties);
        this.azureResourceManager = azureResourceManager;
    }

    @Override
    String getResourceName(Tuple<EventHub, String> key) {
        return key.getSecond();
    }

    @Override
    String getResourceType() {
        return EventHubConsumerGroup.class.getSimpleName();
    }

    @Override
    public EventHubConsumerGroup internalGet(Tuple<EventHub, String> eventHubAndGroup) {
        return eventHubAndGroup.getFirst().listConsumerGroups().stream().filter(c -> c.name().equals(eventHubAndGroup.getSecond())).findAny().orElse(null);
    }

    @Override
    public EventHubConsumerGroup internalCreate(Tuple<EventHub, String> eventHubAndGroup) {
        return (EventHubConsumerGroup)((EventHubConsumerGroup.DefinitionStages.Blank)this.azureResourceManager.eventHubs().consumerGroups().define(eventHubAndGroup.getSecond())).withExistingEventHub(eventHubAndGroup.getFirst()).create();
    }
}

