/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.autoconfigure.b2c.AADB2CJwtGrantedAuthoritiesConverter;
import com.azure.spring.autoconfigure.b2c.AADB2COAuth2AuthenticatedPrincipal;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.util.Assert;

public class AADB2CJwtBearerTokenAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private static final String DEFAULT_AUTHORITY_PREFIX = "SCOPE_";
    private Converter<Jwt, Collection<GrantedAuthority>> converter;
    private String principalClaimName;

    public AADB2CJwtBearerTokenAuthenticationConverter() {
        this.converter = new AADB2CJwtGrantedAuthoritiesConverter();
    }

    public AADB2CJwtBearerTokenAuthenticationConverter(String authoritiesClaimName) {
        this(authoritiesClaimName, DEFAULT_AUTHORITY_PREFIX);
    }

    public AADB2CJwtBearerTokenAuthenticationConverter(String authoritiesClaimName, String authorityPrefix) {
        Assert.notNull((Object)authoritiesClaimName, (String)"authoritiesClaimName cannot be null");
        Assert.notNull((Object)authorityPrefix, (String)"authorityPrefix cannot be null");
        JwtGrantedAuthoritiesConverter jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
        jwtGrantedAuthoritiesConverter.setAuthoritiesClaimName(authoritiesClaimName);
        jwtGrantedAuthoritiesConverter.setAuthorityPrefix(authorityPrefix);
        this.converter = jwtGrantedAuthoritiesConverter;
    }

    protected Collection<GrantedAuthority> extractAuthorities(Jwt jwt) {
        return (Collection)this.converter.convert((Object)jwt);
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt());
        Collection<GrantedAuthority> authorities = this.extractAuthorities(jwt);
        if (this.principalClaimName == null) {
            AADB2COAuth2AuthenticatedPrincipal principal = new AADB2COAuth2AuthenticatedPrincipal(jwt.getHeaders(), jwt.getClaims(), authorities, jwt.getTokenValue());
            return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)principal, accessToken, authorities);
        }
        String name = (String)jwt.getClaim(this.principalClaimName);
        AADB2COAuth2AuthenticatedPrincipal principal = new AADB2COAuth2AuthenticatedPrincipal(jwt.getHeaders(), jwt.getClaims(), authorities, jwt.getTokenValue(), name);
        return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)principal, accessToken, authorities);
    }

    public void setJwtGrantedAuthoritiesConverter(Converter<Jwt, Collection<GrantedAuthority>> jwtGrantedAuthoritiesConverter) {
        this.converter = jwtGrantedAuthoritiesConverter;
    }

    public void setPrincipalClaimName(String principalClaimName) {
        Assert.hasText((String)principalClaimName, (String)"principalClaimName cannot be empty");
        this.principalClaimName = principalClaimName;
    }
}

