/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.azure.spring.autoconfigure.aad.JacksonObjectMapperFactory;
import com.azure.spring.autoconfigure.aad.Membership;
import com.azure.spring.autoconfigure.aad.Memberships;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class GraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClient.class);
    private final AADAuthenticationProperties properties;

    public GraphClient(AADAuthenticationProperties properties) {
        this.properties = properties;
    }

    public Set<String> getGroupsFromGraph(String accessToken) {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        String aadMembershipRestUri = this.properties.getGraphMembershipUri();
        while (aadMembershipRestUri != null) {
            Memberships memberships;
            try {
                String membershipsJson = this.getUserMemberships(accessToken, aadMembershipRestUri);
                memberships = (Memberships)objectMapper.readValue(membershipsJson, Memberships.class);
            }
            catch (IOException ioException) {
                LOGGER.error("Can not get group information from graph server.", (Throwable)ioException);
                break;
            }
            memberships.getValue().stream().filter(this::isGroupObject).map(Membership::getDisplayName).forEach(groups::add);
            aadMembershipRestUri = Optional.of(memberships).map(Memberships::getOdataNextLink).orElse(null);
        }
        return groups;
    }

    private String getUserMemberships(String accessToken, String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(HttpMethod.GET.toString());
        connection.setRequestProperty("Authorization", String.format("Bearer %s", accessToken));
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String responseInJson = this.getResponseString(connection);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            return responseInJson;
        }
        throw new IllegalStateException("Response is not 200, response json: " + responseInJson);
    }

    private String getResponseString(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder stringBuffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuffer.append(line);
            }
            String string = stringBuffer.toString();
            return string;
        }
    }

    private boolean isGroupObject(Membership membership) {
        return membership.getObjectType().equals("#microsoft.graph.group");
    }
}

