/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.keyvault;

import com.azure.spring.keyvault.KeyVaultEnvironmentPostProcessorHelper;
import com.azure.spring.keyvault.KeyVaultProperties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;

public class KeyVaultEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = -2147483637;
    private int order = -2147483637;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        KeyVaultEnvironmentPostProcessorHelper helper = new KeyVaultEnvironmentPostProcessorHelper(environment);
        if (this.hasMultipleKeyVaultsEnabled(environment)) {
            String property = environment.getProperty(KeyVaultProperties.getPropertyName(KeyVaultProperties.Property.ORDER), "");
            String[] keyVaultNames = property.split(",");
            for (int i = keyVaultNames.length - 1; i >= 0; --i) {
                String normalizedName = keyVaultNames[i].trim();
                if (!this.isKeyVaultEnabled(environment, normalizedName)) continue;
                helper.addKeyVaultPropertySource(normalizedName);
            }
        } else if (this.isKeyVaultEnabled(environment, "")) {
            helper.addKeyVaultPropertySource("");
        }
    }

    private boolean isKeyVaultEnabled(ConfigurableEnvironment environment, String normalizedName) {
        return (Boolean)environment.getProperty(KeyVaultProperties.getPropertyName(normalizedName, KeyVaultProperties.Property.ENABLED), Boolean.class, (Object)true) != false && environment.getProperty(KeyVaultProperties.getPropertyName(normalizedName, KeyVaultProperties.Property.URI)) != null && this.isKeyVaultClientAvailable();
    }

    private boolean hasMultipleKeyVaultsEnabled(ConfigurableEnvironment environment) {
        return environment.getProperty(KeyVaultProperties.getPropertyName(KeyVaultProperties.Property.ORDER)) != null;
    }

    private boolean isKeyVaultClientAvailable() {
        return ClassUtils.isPresent((String)"com.azure.security.keyvault.secrets.SecretClient", (ClassLoader)KeyVaultEnvironmentPostProcessor.class.getClassLoader());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

