/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.keyvault;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;

@ConfigurationProperties(value="azure.keyvault")
public class KeyVaultProperties {
    public static final String PREFIX = "azure.keyvault";
    public static final String DELIMITER = ".";
    private Boolean enabled;
    private List<String> secretKeys;
    private Long refreshInterval = 1800000L;
    private String allowTelemetry;
    private String caseSensitiveKeys;
    private String certificatePassword;
    private String certificatePath;
    private String clientId;
    private String clientKey;
    private String order;
    private String tenantId;
    private String uri;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public String getCertificatePassword() {
        return this.certificatePassword;
    }

    public void setCertificatePassword(String certificatePassword) {
        this.certificatePassword = certificatePassword;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(Long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public List<String> getSecretKeys() {
        return this.secretKeys;
    }

    public void setSecretKeys(List<String> secretKeys) {
        this.secretKeys = secretKeys;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getCaseSensitiveKeys() {
        return this.caseSensitiveKeys;
    }

    public void setCaseSensitiveKeys(String caseSensitiveKeys) {
        this.caseSensitiveKeys = caseSensitiveKeys;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Deprecate the telemetry endpoint and use HTTP header User Agent instead.")
    public String getAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(String allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public static String getPropertyName(Property property) {
        return String.join((CharSequence)DELIMITER, PREFIX, property.getName());
    }

    public static String getPropertyName(String normalizedName, Property property) {
        return Stream.of(PREFIX, normalizedName, property.getName()).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(DELIMITER));
    }

    public static enum Property {
        CASE_SENSITIVE_KEYS("case-sensitive-keys"),
        CERTIFICATE_PASSWORD("certificate-password"),
        AUTHORITY_HOST("authority-host"),
        SECRET_SERVICE_VERSION("secret-service-version"),
        CERTIFICATE_PATH("certificate-path"),
        CLIENT_ID("client-id"),
        CLIENT_KEY("client-key"),
        ENABLED("enabled"),
        ORDER("order"),
        REFRESH_INTERVAL("refresh-interval"),
        SECRET_KEYS("secret-keys"),
        TENANT_ID("tenant-id"),
        URI("uri");

        private final String name;

        String getName() {
            return this.name;
        }

        private Property(String name) {
            this.name = name;
        }
    }
}

