/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public abstract class SpringCredentialBuilderBase<T extends SpringCredentialBuilderBase<T>> {
    protected Environment environment;

    public T environment(Environment environment) {
        this.environment = environment;
        return (T)this;
    }

    protected TokenCredential populateTokenCredential(String prefix) {
        return this.populateTokenCredential(prefix, true);
    }

    protected TokenCredential populateTokenCredentialBasedOnClientId(String prefix) {
        return this.populateTokenCredential(prefix, false);
    }

    private TokenCredential populateTokenCredential(String prefix, boolean createDefault) {
        String tenantId = this.getPropertyValue(prefix, "tenant-id");
        String clientId = this.getPropertyValue(prefix, "client-id");
        String clientSecret = this.getPropertyValue(prefix, "client-secret");
        if (tenantId != null && clientId != null && clientSecret != null) {
            return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(tenantId)).clientId(clientId)).clientSecret(clientSecret).build();
        }
        String certPath = this.getPropertyValue(prefix, "client-certificate-path");
        if (tenantId != null && clientId != null && certPath != null) {
            return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(tenantId)).clientId(clientId)).pemCertificate(certPath).build();
        }
        if (clientId != null) {
            return new ManagedIdentityCredentialBuilder().clientId(clientId).build();
        }
        return createDefault ? this.defaultManagedIdentityCredential() : null;
    }

    protected ManagedIdentityCredential defaultManagedIdentityCredential() {
        return new ManagedIdentityCredentialBuilder().build();
    }

    protected String getPropertyValue(String prefix, String propertyKey) {
        return (String)Binder.get((Environment)this.environment).bind(prefix + propertyKey, String.class).orElse(null);
    }
}

