/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.identity;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ChainedTokenCredentialBuilder;
import com.azure.spring.identity.SpringCredentialBuilderBase;
import java.util.ArrayList;
import java.util.List;

public class DefaultSpringCredentialBuilder
extends SpringCredentialBuilderBase<DefaultSpringCredentialBuilder> {
    static final String AZURE_CREDENTIAL_PREFIX = "azure.credential.";
    private String alternativePrefix;

    public DefaultSpringCredentialBuilder alternativePrefix(String alternative) {
        if (alternative != null) {
            this.alternativePrefix = alternative + (alternative.endsWith(".") ? "" : ".");
        }
        return this;
    }

    public TokenCredential build() {
        if (this.environment == null) {
            throw new IllegalArgumentException("To build a spring credential the environment must be set.");
        }
        ArrayList<TokenCredential> tokenCredentials = new ArrayList<TokenCredential>();
        if (this.alternativePrefix != null) {
            this.addToChain(tokenCredentials, this.populateTokenCredentialBasedOnClientId(this.alternativePrefix));
        }
        this.addToChain(tokenCredentials, this.populateTokenCredentialBasedOnClientId(AZURE_CREDENTIAL_PREFIX));
        this.addToChain(tokenCredentials, (TokenCredential)this.defaultManagedIdentityCredential());
        return new ChainedTokenCredentialBuilder().addAll(tokenCredentials).build();
    }

    private void addToChain(List<TokenCredential> chain, TokenCredential tokenCredential) {
        if (tokenCredential != null) {
            chain.add(tokenCredential);
        }
    }
}

