/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiskDetails;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiskVolumeConfiguration;
import java.io.IOException;
import java.util.List;

public final class SapDiskConfiguration
implements JsonSerializable<SapDiskConfiguration> {
    private DiskVolumeConfiguration recommendedConfiguration;
    private List<DiskDetails> supportedConfigurations;

    private SapDiskConfiguration() {
    }

    public DiskVolumeConfiguration recommendedConfiguration() {
        return this.recommendedConfiguration;
    }

    public List<DiskDetails> supportedConfigurations() {
        return this.supportedConfigurations;
    }

    public void validate() {
        if (this.recommendedConfiguration() != null) {
            this.recommendedConfiguration().validate();
        }
        if (this.supportedConfigurations() != null) {
            this.supportedConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recommendedConfiguration", (JsonSerializable)this.recommendedConfiguration);
        jsonWriter.writeArrayField("supportedConfigurations", this.supportedConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SapDiskConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SapDiskConfiguration)jsonReader.readObject(reader -> {
            SapDiskConfiguration deserializedSapDiskConfiguration = new SapDiskConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recommendedConfiguration".equals(fieldName)) {
                    deserializedSapDiskConfiguration.recommendedConfiguration = DiskVolumeConfiguration.fromJson(reader);
                    continue;
                }
                if ("supportedConfigurations".equals(fieldName)) {
                    List supportedConfigurations;
                    deserializedSapDiskConfiguration.supportedConfigurations = supportedConfigurations = reader.readArray(reader1 -> DiskDetails.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapDiskConfiguration;
        });
    }
}

