/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapProductType;
import java.io.IOException;

public final class SapAvailabilityZoneDetailsRequest
implements JsonSerializable<SapAvailabilityZoneDetailsRequest> {
    private String appLocation;
    private SapProductType sapProduct;
    private SapDatabaseType databaseType;
    private static final ClientLogger LOGGER = new ClientLogger(SapAvailabilityZoneDetailsRequest.class);

    public String appLocation() {
        return this.appLocation;
    }

    public SapAvailabilityZoneDetailsRequest withAppLocation(String appLocation) {
        this.appLocation = appLocation;
        return this;
    }

    public SapProductType sapProduct() {
        return this.sapProduct;
    }

    public SapAvailabilityZoneDetailsRequest withSapProduct(SapProductType sapProduct) {
        this.sapProduct = sapProduct;
        return this;
    }

    public SapDatabaseType databaseType() {
        return this.databaseType;
    }

    public SapAvailabilityZoneDetailsRequest withDatabaseType(SapDatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public void validate() {
        if (this.appLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appLocation in model SapAvailabilityZoneDetailsRequest"));
        }
        if (this.sapProduct() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapProduct in model SapAvailabilityZoneDetailsRequest"));
        }
        if (this.databaseType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseType in model SapAvailabilityZoneDetailsRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appLocation", this.appLocation);
        jsonWriter.writeStringField("sapProduct", this.sapProduct == null ? null : this.sapProduct.toString());
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SapAvailabilityZoneDetailsRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SapAvailabilityZoneDetailsRequest)jsonReader.readObject(reader -> {
            SapAvailabilityZoneDetailsRequest deserializedSapAvailabilityZoneDetailsRequest = new SapAvailabilityZoneDetailsRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appLocation".equals(fieldName)) {
                    deserializedSapAvailabilityZoneDetailsRequest.appLocation = reader.getString();
                    continue;
                }
                if ("sapProduct".equals(fieldName)) {
                    deserializedSapAvailabilityZoneDetailsRequest.sapProduct = SapProductType.fromString(reader.getString());
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedSapAvailabilityZoneDetailsRequest.databaseType = SapDatabaseType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapAvailabilityZoneDetailsRequest;
        });
    }
}

