/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OSConfiguration;
import java.io.IOException;

public final class OSProfile
implements JsonSerializable<OSProfile> {
    private String adminUsername;
    private String adminPassword;
    private OSConfiguration osConfiguration;

    public String adminUsername() {
        return this.adminUsername;
    }

    public OSProfile withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public String adminPassword() {
        return this.adminPassword;
    }

    public OSProfile withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public OSConfiguration osConfiguration() {
        return this.osConfiguration;
    }

    public OSProfile withOsConfiguration(OSConfiguration osConfiguration) {
        this.osConfiguration = osConfiguration;
        return this;
    }

    public void validate() {
        if (this.osConfiguration() != null) {
            this.osConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeStringField("adminPassword", this.adminPassword);
        jsonWriter.writeJsonField("osConfiguration", (JsonSerializable)this.osConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static OSProfile fromJson(JsonReader jsonReader) throws IOException {
        return (OSProfile)jsonReader.readObject(reader -> {
            OSProfile deserializedOSProfile = new OSProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminUsername".equals(fieldName)) {
                    deserializedOSProfile.adminUsername = reader.getString();
                    continue;
                }
                if ("adminPassword".equals(fieldName)) {
                    deserializedOSProfile.adminPassword = reader.getString();
                    continue;
                }
                if ("osConfiguration".equals(fieldName)) {
                    deserializedOSProfile.osConfiguration = OSConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSProfile;
        });
    }
}

