/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiskSku;
import java.io.IOException;

public final class DiskDetails
implements JsonSerializable<DiskDetails> {
    private DiskSku sku;
    private Long sizeGB;
    private Long minimumSupportedDiskCount;
    private Long maximumSupportedDiskCount;
    private Long iopsReadWrite;
    private Long mbpsReadWrite;
    private String diskTier;

    private DiskDetails() {
    }

    public DiskSku sku() {
        return this.sku;
    }

    public Long sizeGB() {
        return this.sizeGB;
    }

    public Long minimumSupportedDiskCount() {
        return this.minimumSupportedDiskCount;
    }

    public Long maximumSupportedDiskCount() {
        return this.maximumSupportedDiskCount;
    }

    public Long iopsReadWrite() {
        return this.iopsReadWrite;
    }

    public Long mbpsReadWrite() {
        return this.mbpsReadWrite;
    }

    public String diskTier() {
        return this.diskTier;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeNumberField("sizeGB", (Number)this.sizeGB);
        jsonWriter.writeNumberField("minimumSupportedDiskCount", (Number)this.minimumSupportedDiskCount);
        jsonWriter.writeNumberField("maximumSupportedDiskCount", (Number)this.maximumSupportedDiskCount);
        jsonWriter.writeNumberField("iopsReadWrite", (Number)this.iopsReadWrite);
        jsonWriter.writeNumberField("mbpsReadWrite", (Number)this.mbpsReadWrite);
        jsonWriter.writeStringField("diskTier", this.diskTier);
        return jsonWriter.writeEndObject();
    }

    public static DiskDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DiskDetails)jsonReader.readObject(reader -> {
            DiskDetails deserializedDiskDetails = new DiskDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedDiskDetails.sku = DiskSku.fromJson(reader);
                    continue;
                }
                if ("sizeGB".equals(fieldName)) {
                    deserializedDiskDetails.sizeGB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("minimumSupportedDiskCount".equals(fieldName)) {
                    deserializedDiskDetails.minimumSupportedDiskCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("maximumSupportedDiskCount".equals(fieldName)) {
                    deserializedDiskDetails.maximumSupportedDiskCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("iopsReadWrite".equals(fieldName)) {
                    deserializedDiskDetails.iopsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("mbpsReadWrite".equals(fieldName)) {
                    deserializedDiskDetails.mbpsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskTier".equals(fieldName)) {
                    deserializedDiskDetails.diskTier = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskDetails;
        });
    }
}

