/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfigurationType;
import java.io.IOException;

public final class DiscoveryConfiguration
extends SapConfiguration {
    private SapConfigurationType configurationType = SapConfigurationType.DISCOVERY;
    private String centralServerVmId;
    private String managedRgStorageAccountName;
    private String appLocation;

    @Override
    public SapConfigurationType configurationType() {
        return this.configurationType;
    }

    public String centralServerVmId() {
        return this.centralServerVmId;
    }

    public DiscoveryConfiguration withCentralServerVmId(String centralServerVmId) {
        this.centralServerVmId = centralServerVmId;
        return this;
    }

    public String managedRgStorageAccountName() {
        return this.managedRgStorageAccountName;
    }

    public DiscoveryConfiguration withManagedRgStorageAccountName(String managedRgStorageAccountName) {
        this.managedRgStorageAccountName = managedRgStorageAccountName;
        return this;
    }

    public String appLocation() {
        return this.appLocation;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        jsonWriter.writeStringField("centralServerVmId", this.centralServerVmId);
        jsonWriter.writeStringField("managedRgStorageAccountName", this.managedRgStorageAccountName);
        return jsonWriter.writeEndObject();
    }

    public static DiscoveryConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DiscoveryConfiguration)jsonReader.readObject(reader -> {
            DiscoveryConfiguration deserializedDiscoveryConfiguration = new DiscoveryConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configurationType".equals(fieldName)) {
                    deserializedDiscoveryConfiguration.configurationType = SapConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("centralServerVmId".equals(fieldName)) {
                    deserializedDiscoveryConfiguration.centralServerVmId = reader.getString();
                    continue;
                }
                if ("managedRgStorageAccountName".equals(fieldName)) {
                    deserializedDiscoveryConfiguration.managedRgStorageAccountName = reader.getString();
                    continue;
                }
                if ("appLocation".equals(fieldName)) {
                    deserializedDiscoveryConfiguration.appLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiscoveryConfiguration;
        });
    }
}

