/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.InfrastructureConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OsSapConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfigurationType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SoftwareConfiguration;
import java.io.IOException;

public final class DeploymentWithOSConfiguration
extends SapConfiguration {
    private SapConfigurationType configurationType = SapConfigurationType.DEPLOYMENT_WITH_OSCONFIG;
    private String appLocation;
    private InfrastructureConfiguration infrastructureConfiguration;
    private SoftwareConfiguration softwareConfiguration;
    private OsSapConfiguration osSapConfiguration;

    @Override
    public SapConfigurationType configurationType() {
        return this.configurationType;
    }

    public String appLocation() {
        return this.appLocation;
    }

    public DeploymentWithOSConfiguration withAppLocation(String appLocation) {
        this.appLocation = appLocation;
        return this;
    }

    public InfrastructureConfiguration infrastructureConfiguration() {
        return this.infrastructureConfiguration;
    }

    public DeploymentWithOSConfiguration withInfrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
        this.infrastructureConfiguration = infrastructureConfiguration;
        return this;
    }

    public SoftwareConfiguration softwareConfiguration() {
        return this.softwareConfiguration;
    }

    public DeploymentWithOSConfiguration withSoftwareConfiguration(SoftwareConfiguration softwareConfiguration) {
        this.softwareConfiguration = softwareConfiguration;
        return this;
    }

    public OsSapConfiguration osSapConfiguration() {
        return this.osSapConfiguration;
    }

    public DeploymentWithOSConfiguration withOsSapConfiguration(OsSapConfiguration osSapConfiguration) {
        this.osSapConfiguration = osSapConfiguration;
        return this;
    }

    @Override
    public void validate() {
        if (this.infrastructureConfiguration() != null) {
            this.infrastructureConfiguration().validate();
        }
        if (this.softwareConfiguration() != null) {
            this.softwareConfiguration().validate();
        }
        if (this.osSapConfiguration() != null) {
            this.osSapConfiguration().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        jsonWriter.writeStringField("appLocation", this.appLocation);
        jsonWriter.writeJsonField("infrastructureConfiguration", (JsonSerializable)this.infrastructureConfiguration);
        jsonWriter.writeJsonField("softwareConfiguration", (JsonSerializable)this.softwareConfiguration);
        jsonWriter.writeJsonField("osSapConfiguration", (JsonSerializable)this.osSapConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentWithOSConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentWithOSConfiguration)jsonReader.readObject(reader -> {
            DeploymentWithOSConfiguration deserializedDeploymentWithOSConfiguration = new DeploymentWithOSConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configurationType".equals(fieldName)) {
                    deserializedDeploymentWithOSConfiguration.configurationType = SapConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("appLocation".equals(fieldName)) {
                    deserializedDeploymentWithOSConfiguration.appLocation = reader.getString();
                    continue;
                }
                if ("infrastructureConfiguration".equals(fieldName)) {
                    deserializedDeploymentWithOSConfiguration.infrastructureConfiguration = InfrastructureConfiguration.fromJson(reader);
                    continue;
                }
                if ("softwareConfiguration".equals(fieldName)) {
                    deserializedDeploymentWithOSConfiguration.softwareConfiguration = SoftwareConfiguration.fromJson(reader);
                    continue;
                }
                if ("osSapConfiguration".equals(fieldName)) {
                    deserializedDeploymentWithOSConfiguration.osSapConfiguration = OsSapConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentWithOSConfiguration;
        });
    }
}

