/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ApplicationServerVirtualMachineType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StorageInformation;
import java.io.IOException;
import java.util.List;

public final class ApplicationServerVmDetails
implements JsonSerializable<ApplicationServerVmDetails> {
    private ApplicationServerVirtualMachineType type;
    private String virtualMachineId;
    private List<StorageInformation> storageDetails;

    private ApplicationServerVmDetails() {
    }

    public ApplicationServerVirtualMachineType type() {
        return this.type;
    }

    public String virtualMachineId() {
        return this.virtualMachineId;
    }

    public List<StorageInformation> storageDetails() {
        return this.storageDetails;
    }

    public void validate() {
        if (this.storageDetails() != null) {
            this.storageDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ApplicationServerVmDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationServerVmDetails)jsonReader.readObject(reader -> {
            ApplicationServerVmDetails deserializedApplicationServerVmDetails = new ApplicationServerVmDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedApplicationServerVmDetails.type = ApplicationServerVirtualMachineType.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachineId".equals(fieldName)) {
                    deserializedApplicationServerVmDetails.virtualMachineId = reader.getString();
                    continue;
                }
                if ("storageDetails".equals(fieldName)) {
                    List storageDetails;
                    deserializedApplicationServerVmDetails.storageDetails = storageDetails = reader.readArray(reader1 -> StorageInformation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationServerVmDetails;
        });
    }
}

