/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.SapVirtualInstancesClient;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapAvailabilityZoneDetailsResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapDiskConfigurationsResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapSizingRecommendationResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapSupportedResourceSkusResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapVirtualInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapAvailabilityZoneDetailsResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapDiskConfigurationsResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapSizingRecommendationResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapSupportedResourceSkusResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapVirtualInstanceImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapAvailabilityZoneDetailsRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapAvailabilityZoneDetailsResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDiskConfigurationsRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDiskConfigurationsResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSizingRecommendationRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSizingRecommendationResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSupportedResourceSkusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapSupportedSkusRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstances;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;

public final class SapVirtualInstancesImpl
implements SapVirtualInstances {
    private static final ClientLogger LOGGER = new ClientLogger(SapVirtualInstancesImpl.class);
    private final SapVirtualInstancesClient innerClient;
    private final WorkloadsSapVirtualInstanceManager serviceManager;

    public SapVirtualInstancesImpl(SapVirtualInstancesClient innerClient, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SapVirtualInstance> getByResourceGroupWithResponse(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        Response<SapVirtualInstanceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, sapVirtualInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapVirtualInstanceImpl((SapVirtualInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SapVirtualInstance getByResourceGroup(String resourceGroupName, String sapVirtualInstanceName) {
        SapVirtualInstanceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, sapVirtualInstanceName);
        if (inner != null) {
            return new SapVirtualInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String sapVirtualInstanceName) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, context);
    }

    @Override
    public PagedIterable<SapVirtualInstance> listByResourceGroup(String resourceGroupName) {
        PagedIterable<SapVirtualInstanceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapVirtualInstanceImpl((SapVirtualInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SapVirtualInstance> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<SapVirtualInstanceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapVirtualInstanceImpl((SapVirtualInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SapVirtualInstance> list() {
        PagedIterable<SapVirtualInstanceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapVirtualInstanceImpl((SapVirtualInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SapVirtualInstance> list(Context context) {
        PagedIterable<SapVirtualInstanceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapVirtualInstanceImpl((SapVirtualInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, StartRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, StopRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SapSizingRecommendationResult> getSizingRecommendationsWithResponse(String location, SapSizingRecommendationRequest body, Context context) {
        Response<SapSizingRecommendationResultInner> inner = this.serviceClient().getSizingRecommendationsWithResponse(location, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapSizingRecommendationResultImpl((SapSizingRecommendationResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SapSizingRecommendationResult getSizingRecommendations(String location, SapSizingRecommendationRequest body) {
        SapSizingRecommendationResultInner inner = this.serviceClient().getSizingRecommendations(location, body);
        if (inner != null) {
            return new SapSizingRecommendationResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SapSupportedResourceSkusResult> getSapSupportedSkuWithResponse(String location, SapSupportedSkusRequest body, Context context) {
        Response<SapSupportedResourceSkusResultInner> inner = this.serviceClient().getSapSupportedSkuWithResponse(location, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapSupportedResourceSkusResultImpl((SapSupportedResourceSkusResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SapSupportedResourceSkusResult getSapSupportedSku(String location, SapSupportedSkusRequest body) {
        SapSupportedResourceSkusResultInner inner = this.serviceClient().getSapSupportedSku(location, body);
        if (inner != null) {
            return new SapSupportedResourceSkusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SapDiskConfigurationsResult> getDiskConfigurationsWithResponse(String location, SapDiskConfigurationsRequest body, Context context) {
        Response<SapDiskConfigurationsResultInner> inner = this.serviceClient().getDiskConfigurationsWithResponse(location, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapDiskConfigurationsResultImpl((SapDiskConfigurationsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SapDiskConfigurationsResult getDiskConfigurations(String location, SapDiskConfigurationsRequest body) {
        SapDiskConfigurationsResultInner inner = this.serviceClient().getDiskConfigurations(location, body);
        if (inner != null) {
            return new SapDiskConfigurationsResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SapAvailabilityZoneDetailsResult> getAvailabilityZoneDetailsWithResponse(String location, SapAvailabilityZoneDetailsRequest body, Context context) {
        Response<SapAvailabilityZoneDetailsResultInner> inner = this.serviceClient().getAvailabilityZoneDetailsWithResponse(location, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapAvailabilityZoneDetailsResultImpl((SapAvailabilityZoneDetailsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SapAvailabilityZoneDetailsResult getAvailabilityZoneDetails(String location, SapAvailabilityZoneDetailsRequest body) {
        SapAvailabilityZoneDetailsResultInner inner = this.serviceClient().getAvailabilityZoneDetails(location, body);
        if (inner != null) {
            return new SapAvailabilityZoneDetailsResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SapVirtualInstance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        return (SapVirtualInstance)this.getByResourceGroupWithResponse(resourceGroupName, sapVirtualInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<SapVirtualInstance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, sapVirtualInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, context);
    }

    private SapVirtualInstancesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapVirtualInstanceImpl define(String name) {
        return new SapVirtualInstanceImpl(name, this.manager());
    }
}

