/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.SapApplicationServerInstancesClient;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapApplicationServerInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.WorkloadsSapVirtualInstanceMgmtClientImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.models.SAPApplicationServerInstanceListResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapApplicationInstanceRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SapApplicationServerInstancesClientImpl
implements SapApplicationServerInstancesClient {
    private final SapApplicationServerInstancesService service;
    private final WorkloadsSapVirtualInstanceMgmtClientImpl client;

    SapApplicationServerInstancesClientImpl(WorkloadsSapVirtualInstanceMgmtClientImpl client) {
        this.service = (SapApplicationServerInstancesService)RestProxy.create(SapApplicationServerInstancesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SapApplicationServerInstanceInner>> getWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SapApplicationServerInstanceInner>> getWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SapApplicationServerInstanceInner> getAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        return this.getWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SapApplicationServerInstanceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SapApplicationServerInstanceInner> getWithResponse(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SapApplicationServerInstanceInner get(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        return (SapApplicationServerInstanceInner)((Object)this.getWithResponse(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SapApplicationServerInstanceInner>, SapApplicationServerInstanceInner> beginCreateAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SapApplicationServerInstanceInner.class), (Type)((Object)SapApplicationServerInstanceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SapApplicationServerInstanceInner>, SapApplicationServerInstanceInner> beginCreateAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SapApplicationServerInstanceInner.class), (Type)((Object)SapApplicationServerInstanceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SapApplicationServerInstanceInner>, SapApplicationServerInstanceInner> beginCreate(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource) {
        return this.beginCreateAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SapApplicationServerInstanceInner>, SapApplicationServerInstanceInner> beginCreate(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource, Context context) {
        return this.beginCreateAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SapApplicationServerInstanceInner> createAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource) {
        return this.beginCreateAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SapApplicationServerInstanceInner> createAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource, Context context) {
        return this.beginCreateAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SapApplicationServerInstanceInner create(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource) {
        return (SapApplicationServerInstanceInner)((Object)this.createAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SapApplicationServerInstanceInner create(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, SapApplicationServerInstanceInner resource, Context context) {
        return (SapApplicationServerInstanceInner)((Object)this.createAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, resource, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SapApplicationServerInstanceInner>> updateWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, UpdateSapApplicationInstanceRequest properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SapApplicationServerInstanceInner>> updateWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, UpdateSapApplicationInstanceRequest properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SapApplicationServerInstanceInner> updateAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, UpdateSapApplicationInstanceRequest properties) {
        return this.updateWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, properties).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SapApplicationServerInstanceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SapApplicationServerInstanceInner> updateWithResponse(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, UpdateSapApplicationInstanceRequest properties, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, properties, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SapApplicationServerInstanceInner update(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, UpdateSapApplicationInstanceRequest properties) {
        return (SapApplicationServerInstanceInner)((Object)this.updateWithResponse(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, properties, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        return this.beginDeleteAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        return this.beginDeleteAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        this.deleteAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        this.deleteAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SapApplicationServerInstanceInner>> listSinglePageAsync(String resourceGroupName, String sapVirtualInstanceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SAPApplicationServerInstanceListResult)res.getValue()).value(), ((SAPApplicationServerInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SapApplicationServerInstanceInner>> listSinglePageAsync(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SAPApplicationServerInstanceListResult)res.getValue()).value(), ((SAPApplicationServerInstanceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SapApplicationServerInstanceInner> listAsync(String resourceGroupName, String sapVirtualInstanceName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, sapVirtualInstanceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SapApplicationServerInstanceInner> listAsync(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, sapVirtualInstanceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SapApplicationServerInstanceInner> list(String resourceGroupName, String sapVirtualInstanceName) {
        return new PagedIterable(this.listAsync(resourceGroupName, sapVirtualInstanceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SapApplicationServerInstanceInner> list(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, sapVirtualInstanceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStartAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStartAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StartRequest body = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStartAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStart(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StartRequest body = null;
        return this.beginStartAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStart(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body, Context context) {
        return this.beginStartAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> startAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body) {
        return this.beginStartAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> startAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StartRequest body = null;
        return this.beginStartAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> startAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body, Context context) {
        return this.beginStartAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner start(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StartRequest body = null;
        return (OperationStatusResultInner)this.startAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner start(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body, Context context) {
        return (OperationStatusResultInner)this.startAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sapVirtualInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sapVirtualInstanceName is required and cannot be null."));
        }
        if (applicationInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationInstanceName is required and cannot be null."));
        }
        if (body != null) {
            body.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stop(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, sapVirtualInstanceName, applicationInstanceName, "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStopAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStopAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StopRequest body = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStopAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.stopWithResponseAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStop(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StopRequest body = null;
        return this.beginStopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginStop(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body, Context context) {
        return this.beginStopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> stopAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body) {
        return this.beginStopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> stopAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StopRequest body = null;
        return this.beginStopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> stopAsync(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body, Context context) {
        return this.beginStopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner stop(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        StopRequest body = null;
        return (OperationStatusResultInner)this.stopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner stop(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body, Context context) {
        return (OperationStatusResultInner)this.stopAsync(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SapApplicationServerInstanceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SAPApplicationServerInstanceListResult)res.getValue()).value(), ((SAPApplicationServerInstanceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SapApplicationServerInstanceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SAPApplicationServerInstanceListResult)res.getValue()).value(), ((SAPApplicationServerInstanceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="WorkloadsSapVirtualI")
    public static interface SapApplicationServerInstancesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SapApplicationServerInstanceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @PathParam(value="applicationInstanceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @PathParam(value="applicationInstanceName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SapApplicationServerInstanceInner var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SapApplicationServerInstanceInner>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @PathParam(value="applicationInstanceName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") UpdateSapApplicationInstanceRequest var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @PathParam(value="applicationInstanceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SAPApplicationServerInstanceListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @PathParam(value="applicationInstanceName") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") StartRequest var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}/applicationInstances/{applicationInstanceName}/stop")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> stop(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="sapVirtualInstanceName") String var5, @PathParam(value="applicationInstanceName") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") StopRequest var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SAPApplicationServerInstanceListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

