/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapApplicationServerInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapApplicationServerInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapApplicationServerProperties;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.UpdateSapApplicationInstanceRequest;
import java.util.Collections;
import java.util.Map;

public final class SapApplicationServerInstanceImpl
implements SapApplicationServerInstance,
SapApplicationServerInstance.Definition,
SapApplicationServerInstance.Update {
    private SapApplicationServerInstanceInner innerObject;
    private final WorkloadsSapVirtualInstanceManager serviceManager;
    private String resourceGroupName;
    private String sapVirtualInstanceName;
    private String applicationInstanceName;
    private UpdateSapApplicationInstanceRequest updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SapApplicationServerProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SapApplicationServerInstanceInner innerModel() {
        return this.innerObject;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapApplicationServerInstanceImpl withExistingSapVirtualInstance(String resourceGroupName, String sapVirtualInstanceName) {
        this.resourceGroupName = resourceGroupName;
        this.sapVirtualInstanceName = sapVirtualInstanceName;
        return this;
    }

    @Override
    public SapApplicationServerInstance create() {
        this.innerObject = this.serviceManager.serviceClient().getSapApplicationServerInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SapApplicationServerInstance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSapApplicationServerInstances().create(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, this.innerModel(), context);
        return this;
    }

    SapApplicationServerInstanceImpl(String name, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = new SapApplicationServerInstanceInner();
        this.serviceManager = serviceManager;
        this.applicationInstanceName = name;
    }

    @Override
    public SapApplicationServerInstanceImpl update() {
        this.updateProperties = new UpdateSapApplicationInstanceRequest();
        return this;
    }

    @Override
    public SapApplicationServerInstance apply() {
        this.innerObject = (SapApplicationServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapApplicationServerInstances().updateWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, this.updateProperties, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapApplicationServerInstance apply(Context context) {
        this.innerObject = (SapApplicationServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapApplicationServerInstances().updateWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, this.updateProperties, context).getValue());
        return this;
    }

    SapApplicationServerInstanceImpl(SapApplicationServerInstanceInner innerObject, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sapVirtualInstances");
        this.applicationInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "applicationInstances");
    }

    @Override
    public SapApplicationServerInstance refresh() {
        this.innerObject = (SapApplicationServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapApplicationServerInstances().getWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SapApplicationServerInstance refresh(Context context) {
        this.innerObject = (SapApplicationServerInstanceInner)((Object)this.serviceManager.serviceClient().getSapApplicationServerInstances().getWithResponse(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, context).getValue());
        return this;
    }

    @Override
    public OperationStatusResult start() {
        return this.serviceManager.sapApplicationServerInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName);
    }

    @Override
    public OperationStatusResult start(StartRequest body, Context context) {
        return this.serviceManager.sapApplicationServerInstances().start(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, body, context);
    }

    @Override
    public OperationStatusResult stop() {
        return this.serviceManager.sapApplicationServerInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName);
    }

    @Override
    public OperationStatusResult stop(StopRequest body, Context context) {
        return this.serviceManager.sapApplicationServerInstances().stop(this.resourceGroupName, this.sapVirtualInstanceName, this.applicationInstanceName, body, context);
    }

    @Override
    public SapApplicationServerInstanceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SapApplicationServerInstanceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SapApplicationServerInstanceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public SapApplicationServerInstanceImpl withProperties(SapApplicationServerProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

