/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SAPVirtualInstanceIdentity;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapVirtualInstanceProperties;
import java.io.IOException;
import java.util.Map;

public final class SapVirtualInstanceInner
extends Resource {
    private SapVirtualInstanceProperties properties;
    private SAPVirtualInstanceIdentity identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public SapVirtualInstanceProperties properties() {
        return this.properties;
    }

    public SapVirtualInstanceInner withProperties(SapVirtualInstanceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SAPVirtualInstanceIdentity identity() {
        return this.identity;
    }

    public SapVirtualInstanceInner withIdentity(SAPVirtualInstanceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public SapVirtualInstanceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SapVirtualInstanceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static SapVirtualInstanceInner fromJson(JsonReader jsonReader) throws IOException {
        return (SapVirtualInstanceInner)((Object)jsonReader.readObject(reader -> {
            SapVirtualInstanceInner deserializedSapVirtualInstanceInner = new SapVirtualInstanceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSapVirtualInstanceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.properties = SapVirtualInstanceProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.identity = SAPVirtualInstanceIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSapVirtualInstanceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapVirtualInstanceInner;
        }));
    }
}

