/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import com.azure.resourcemanager.workloadorchestration.models.StageSpec;
import com.azure.resourcemanager.workloadorchestration.models.State;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class WorkflowVersionProperties
implements JsonSerializable<WorkflowVersionProperties> {
    private Integer revision;
    private String configuration;
    private List<StageSpec> stageSpec;
    private String reviewId;
    private State state;
    private Map<String, BinaryData> specification;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowVersionProperties.class);

    public Integer revision() {
        return this.revision;
    }

    public String configuration() {
        return this.configuration;
    }

    public List<StageSpec> stageSpec() {
        return this.stageSpec;
    }

    public WorkflowVersionProperties withStageSpec(List<StageSpec> stageSpec) {
        this.stageSpec = stageSpec;
        return this;
    }

    public String reviewId() {
        return this.reviewId;
    }

    public State state() {
        return this.state;
    }

    public Map<String, BinaryData> specification() {
        return this.specification;
    }

    public WorkflowVersionProperties withSpecification(Map<String, BinaryData> specification) {
        this.specification = specification;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.stageSpec() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property stageSpec in model WorkflowVersionProperties"));
        }
        this.stageSpec().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("stageSpec", this.stageSpec, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("specification", this.specification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        return jsonWriter.writeEndObject();
    }

    public static WorkflowVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowVersionProperties)jsonReader.readObject(reader -> {
            WorkflowVersionProperties deserializedWorkflowVersionProperties = new WorkflowVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("stageSpec".equals(fieldName)) {
                    List stageSpec;
                    deserializedWorkflowVersionProperties.stageSpec = stageSpec = reader.readArray(reader1 -> StageSpec.fromJson(reader1));
                    continue;
                }
                if ("revision".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.revision = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.configuration = reader.getString();
                    continue;
                }
                if ("reviewId".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.reviewId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.state = State.fromString(reader.getString());
                    continue;
                }
                if ("specification".equals(fieldName)) {
                    Map specification;
                    deserializedWorkflowVersionProperties.specification = specification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowVersionProperties;
        });
    }
}

