/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class TaskSpec
implements JsonSerializable<TaskSpec> {
    private String name;
    private String targetId;
    private Map<String, BinaryData> specification;
    private static final ClientLogger LOGGER = new ClientLogger(TaskSpec.class);

    public String name() {
        return this.name;
    }

    public TaskSpec withName(String name) {
        this.name = name;
        return this;
    }

    public String targetId() {
        return this.targetId;
    }

    public TaskSpec withTargetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    public Map<String, BinaryData> specification() {
        return this.specification;
    }

    public TaskSpec withSpecification(Map<String, BinaryData> specification) {
        this.specification = specification;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model TaskSpec"));
        }
        if (this.specification() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property specification in model TaskSpec"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("specification", this.specification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("targetId", this.targetId);
        return jsonWriter.writeEndObject();
    }

    public static TaskSpec fromJson(JsonReader jsonReader) throws IOException {
        return (TaskSpec)jsonReader.readObject(reader -> {
            TaskSpec deserializedTaskSpec = new TaskSpec();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTaskSpec.name = reader.getString();
                    continue;
                }
                if ("specification".equals(fieldName)) {
                    Map specification;
                    deserializedTaskSpec.specification = specification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("targetId".equals(fieldName)) {
                    deserializedTaskSpec.targetId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskSpec;
        });
    }
}

