/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ErrorAction;
import java.io.IOException;

public final class TaskOption
implements JsonSerializable<TaskOption> {
    private Integer concurrency;
    private ErrorAction errorAction;

    public Integer concurrency() {
        return this.concurrency;
    }

    public TaskOption withConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public ErrorAction errorAction() {
        return this.errorAction;
    }

    public TaskOption withErrorAction(ErrorAction errorAction) {
        this.errorAction = errorAction;
        return this;
    }

    public void validate() {
        if (this.errorAction() != null) {
            this.errorAction().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("concurrency", (Number)this.concurrency);
        jsonWriter.writeJsonField("errorAction", (JsonSerializable)this.errorAction);
        return jsonWriter.writeEndObject();
    }

    public static TaskOption fromJson(JsonReader jsonReader) throws IOException {
        return (TaskOption)jsonReader.readObject(reader -> {
            TaskOption deserializedTaskOption = new TaskOption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("concurrency".equals(fieldName)) {
                    deserializedTaskOption.concurrency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errorAction".equals(fieldName)) {
                    deserializedTaskOption.errorAction = ErrorAction.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskOption;
        });
    }
}

