/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class TargetSnapshot
implements JsonSerializable<TargetSnapshot> {
    private String targetId;
    private Map<String, BinaryData> targetSpecification;
    private String solutionScope;

    private TargetSnapshot() {
    }

    public String targetId() {
        return this.targetId;
    }

    public Map<String, BinaryData> targetSpecification() {
        return this.targetSpecification;
    }

    public String solutionScope() {
        return this.solutionScope;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetId", this.targetId);
        jsonWriter.writeMapField("targetSpecification", this.targetSpecification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("solutionScope", this.solutionScope);
        return jsonWriter.writeEndObject();
    }

    public static TargetSnapshot fromJson(JsonReader jsonReader) throws IOException {
        return (TargetSnapshot)jsonReader.readObject(reader -> {
            TargetSnapshot deserializedTargetSnapshot = new TargetSnapshot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetId".equals(fieldName)) {
                    deserializedTargetSnapshot.targetId = reader.getString();
                    continue;
                }
                if ("targetSpecification".equals(fieldName)) {
                    Map targetSpecification;
                    deserializedTargetSnapshot.targetSpecification = targetSpecification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("solutionScope".equals(fieldName)) {
                    deserializedTargetSnapshot.solutionScope = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetSnapshot;
        });
    }
}

