/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ActiveState;
import java.io.IOException;
import java.util.Map;

public final class StageStatus
implements JsonSerializable<StageStatus> {
    private Integer status;
    private String statusMessage;
    private String stage;
    private String nextstage;
    private String errorMessage;
    private ActiveState isActive;
    private Map<String, BinaryData> inputs;
    private Map<String, BinaryData> outputs;

    private StageStatus() {
    }

    public Integer status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public String stage() {
        return this.stage;
    }

    public String nextstage() {
        return this.nextstage;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public ActiveState isActive() {
        return this.isActive;
    }

    public Map<String, BinaryData> inputs() {
        return this.inputs;
    }

    public Map<String, BinaryData> outputs() {
        return this.outputs;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("status", (Number)this.status);
        jsonWriter.writeStringField("statusMessage", this.statusMessage);
        jsonWriter.writeStringField("stage", this.stage);
        jsonWriter.writeStringField("nextstage", this.nextstage);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        jsonWriter.writeStringField("isActive", this.isActive == null ? null : this.isActive.toString());
        jsonWriter.writeMapField("inputs", this.inputs, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeMapField("outputs", this.outputs, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        return jsonWriter.writeEndObject();
    }

    public static StageStatus fromJson(JsonReader jsonReader) throws IOException {
        return (StageStatus)jsonReader.readObject(reader -> {
            StageStatus deserializedStageStatus = new StageStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedStageStatus.status = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedStageStatus.statusMessage = reader.getString();
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedStageStatus.stage = reader.getString();
                    continue;
                }
                if ("nextstage".equals(fieldName)) {
                    deserializedStageStatus.nextstage = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedStageStatus.errorMessage = reader.getString();
                    continue;
                }
                if ("isActive".equals(fieldName)) {
                    deserializedStageStatus.isActive = ActiveState.fromString(reader.getString());
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    Map inputs;
                    deserializedStageStatus.inputs = inputs = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    Map outputs;
                    deserializedStageStatus.outputs = outputs = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStageStatus;
        });
    }
}

