/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.TaskOption;
import com.azure.resourcemanager.workloadorchestration.models.TaskSpec;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class StageSpec
implements JsonSerializable<StageSpec> {
    private String name;
    private Map<String, BinaryData> specification;
    private List<TaskSpec> tasks;
    private TaskOption taskOption;
    private static final ClientLogger LOGGER = new ClientLogger(StageSpec.class);

    public String name() {
        return this.name;
    }

    public StageSpec withName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, BinaryData> specification() {
        return this.specification;
    }

    public StageSpec withSpecification(Map<String, BinaryData> specification) {
        this.specification = specification;
        return this;
    }

    public List<TaskSpec> tasks() {
        return this.tasks;
    }

    public StageSpec withTasks(List<TaskSpec> tasks) {
        this.tasks = tasks;
        return this;
    }

    public TaskOption taskOption() {
        return this.taskOption;
    }

    public StageSpec withTaskOption(TaskOption taskOption) {
        this.taskOption = taskOption;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model StageSpec"));
        }
        if (this.tasks() != null) {
            this.tasks().forEach(e -> e.validate());
        }
        if (this.taskOption() != null) {
            this.taskOption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("specification", this.specification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("taskOption", (JsonSerializable)this.taskOption);
        return jsonWriter.writeEndObject();
    }

    public static StageSpec fromJson(JsonReader jsonReader) throws IOException {
        return (StageSpec)jsonReader.readObject(reader -> {
            StageSpec deserializedStageSpec = new StageSpec();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedStageSpec.name = reader.getString();
                    continue;
                }
                if ("specification".equals(fieldName)) {
                    Map specification;
                    deserializedStageSpec.specification = specification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    List tasks;
                    deserializedStageSpec.tasks = tasks = reader.readArray(reader1 -> TaskSpec.fromJson(reader1));
                    continue;
                }
                if ("taskOption".equals(fieldName)) {
                    deserializedStageSpec.taskOption = TaskOption.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStageSpec;
        });
    }
}

