/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.OrchestratorType;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class SolutionTemplateVersionProperties
implements JsonSerializable<SolutionTemplateVersionProperties> {
    private String configurations;
    private Map<String, BinaryData> specification;
    private OrchestratorType orchestratorType;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplateVersionProperties.class);

    public String configurations() {
        return this.configurations;
    }

    public SolutionTemplateVersionProperties withConfigurations(String configurations) {
        this.configurations = configurations;
        return this;
    }

    public Map<String, BinaryData> specification() {
        return this.specification;
    }

    public SolutionTemplateVersionProperties withSpecification(Map<String, BinaryData> specification) {
        this.specification = specification;
        return this;
    }

    public OrchestratorType orchestratorType() {
        return this.orchestratorType;
    }

    public SolutionTemplateVersionProperties withOrchestratorType(OrchestratorType orchestratorType) {
        this.orchestratorType = orchestratorType;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.configurations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property configurations in model SolutionTemplateVersionProperties"));
        }
        if (this.specification() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property specification in model SolutionTemplateVersionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("configurations", this.configurations);
        jsonWriter.writeMapField("specification", this.specification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("orchestratorType", this.orchestratorType == null ? null : this.orchestratorType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SolutionTemplateVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionTemplateVersionProperties)jsonReader.readObject(reader -> {
            SolutionTemplateVersionProperties deserializedSolutionTemplateVersionProperties = new SolutionTemplateVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configurations".equals(fieldName)) {
                    deserializedSolutionTemplateVersionProperties.configurations = reader.getString();
                    continue;
                }
                if ("specification".equals(fieldName)) {
                    Map specification;
                    deserializedSolutionTemplateVersionProperties.specification = specification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("orchestratorType".equals(fieldName)) {
                    deserializedSolutionTemplateVersionProperties.orchestratorType = OrchestratorType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSolutionTemplateVersionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionTemplateVersionProperties;
        });
    }
}

