/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import com.azure.resourcemanager.workloadorchestration.models.ResourceState;
import java.io.IOException;
import java.util.List;

public final class SolutionTemplateProperties
implements JsonSerializable<SolutionTemplateProperties> {
    private String description;
    private List<String> capabilities;
    private String latestVersion;
    private ResourceState state;
    private Boolean enableExternalValidation;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplateProperties.class);

    public String description() {
        return this.description;
    }

    public SolutionTemplateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public SolutionTemplateProperties withCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public ResourceState state() {
        return this.state;
    }

    public SolutionTemplateProperties withState(ResourceState state) {
        this.state = state;
        return this;
    }

    public Boolean enableExternalValidation() {
        return this.enableExternalValidation;
    }

    public SolutionTemplateProperties withEnableExternalValidation(Boolean enableExternalValidation) {
        this.enableExternalValidation = enableExternalValidation;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model SolutionTemplateProperties"));
        }
        if (this.capabilities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capabilities in model SolutionTemplateProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeBooleanField("enableExternalValidation", this.enableExternalValidation);
        return jsonWriter.writeEndObject();
    }

    public static SolutionTemplateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionTemplateProperties)jsonReader.readObject(reader -> {
            SolutionTemplateProperties deserializedSolutionTemplateProperties = new SolutionTemplateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedSolutionTemplateProperties.description = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSolutionTemplateProperties.capabilities = capabilities = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("latestVersion".equals(fieldName)) {
                    deserializedSolutionTemplateProperties.latestVersion = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSolutionTemplateProperties.state = ResourceState.fromString(reader.getString());
                    continue;
                }
                if ("enableExternalValidation".equals(fieldName)) {
                    deserializedSolutionTemplateProperties.enableExternalValidation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSolutionTemplateProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionTemplateProperties;
        });
    }
}

