/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.SolutionDependencyParameter;
import java.io.IOException;
import java.util.List;

public final class SolutionTemplateParameter
implements JsonSerializable<SolutionTemplateParameter> {
    private String solutionTemplateVersionId;
    private String solutionInstanceName;
    private List<SolutionDependencyParameter> solutionDependencies;
    private static final ClientLogger LOGGER = new ClientLogger(SolutionTemplateParameter.class);

    public String solutionTemplateVersionId() {
        return this.solutionTemplateVersionId;
    }

    public SolutionTemplateParameter withSolutionTemplateVersionId(String solutionTemplateVersionId) {
        this.solutionTemplateVersionId = solutionTemplateVersionId;
        return this;
    }

    public String solutionInstanceName() {
        return this.solutionInstanceName;
    }

    public SolutionTemplateParameter withSolutionInstanceName(String solutionInstanceName) {
        this.solutionInstanceName = solutionInstanceName;
        return this;
    }

    public List<SolutionDependencyParameter> solutionDependencies() {
        return this.solutionDependencies;
    }

    public SolutionTemplateParameter withSolutionDependencies(List<SolutionDependencyParameter> solutionDependencies) {
        this.solutionDependencies = solutionDependencies;
        return this;
    }

    public void validate() {
        if (this.solutionTemplateVersionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property solutionTemplateVersionId in model SolutionTemplateParameter"));
        }
        if (this.solutionDependencies() != null) {
            this.solutionDependencies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("solutionTemplateVersionId", this.solutionTemplateVersionId);
        jsonWriter.writeStringField("solutionInstanceName", this.solutionInstanceName);
        jsonWriter.writeArrayField("solutionDependencies", this.solutionDependencies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SolutionTemplateParameter fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionTemplateParameter)jsonReader.readObject(reader -> {
            SolutionTemplateParameter deserializedSolutionTemplateParameter = new SolutionTemplateParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionTemplateVersionId".equals(fieldName)) {
                    deserializedSolutionTemplateParameter.solutionTemplateVersionId = reader.getString();
                    continue;
                }
                if ("solutionInstanceName".equals(fieldName)) {
                    deserializedSolutionTemplateParameter.solutionInstanceName = reader.getString();
                    continue;
                }
                if ("solutionDependencies".equals(fieldName)) {
                    List solutionDependencies;
                    deserializedSolutionTemplateParameter.solutionDependencies = solutionDependencies = reader.readArray(reader1 -> SolutionDependencyParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionTemplateParameter;
        });
    }
}

