/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ReconciliationState;
import java.io.IOException;

public final class ReconciliationPolicyProperties
implements JsonSerializable<ReconciliationPolicyProperties> {
    private ReconciliationState state;
    private String interval;
    private static final ClientLogger LOGGER = new ClientLogger(ReconciliationPolicyProperties.class);

    public ReconciliationState state() {
        return this.state;
    }

    public ReconciliationPolicyProperties withState(ReconciliationState state) {
        this.state = state;
        return this;
    }

    public String interval() {
        return this.interval;
    }

    public ReconciliationPolicyProperties withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    public void validate() {
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model ReconciliationPolicyProperties"));
        }
        if (this.interval() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property interval in model ReconciliationPolicyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("interval", this.interval);
        return jsonWriter.writeEndObject();
    }

    public static ReconciliationPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ReconciliationPolicyProperties)jsonReader.readObject(reader -> {
            ReconciliationPolicyProperties deserializedReconciliationPolicyProperties = new ReconciliationPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedReconciliationPolicyProperties.state = ReconciliationState.fromString(reader.getString());
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedReconciliationPolicyProperties.interval = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReconciliationPolicyProperties;
        });
    }
}

