/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.JobStatus;
import com.azure.resourcemanager.workloadorchestration.models.JobStepStatisticsBase;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class JobStep
implements JsonSerializable<JobStep> {
    private String name;
    private JobStatus status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private String message;
    private JobStepStatisticsBase statistics;
    private List<JobStep> steps;
    private ManagementError errorDetails;
    private static final ClientLogger LOGGER = new ClientLogger(JobStep.class);

    private JobStep() {
    }

    public String name() {
        return this.name;
    }

    public JobStatus status() {
        return this.status;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public String message() {
        return this.message;
    }

    public JobStepStatisticsBase statistics() {
        return this.statistics;
    }

    public List<JobStep> steps() {
        return this.steps;
    }

    public ManagementError errorDetails() {
        return this.errorDetails;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model JobStep"));
        }
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model JobStep"));
        }
        if (this.statistics() != null) {
            this.statistics().validate();
        }
        if (this.steps() != null) {
            this.steps().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.statistics);
        jsonWriter.writeArrayField("steps", this.steps, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobStep fromJson(JsonReader jsonReader) throws IOException {
        return (JobStep)jsonReader.readObject(reader -> {
            JobStep deserializedJobStep = new JobStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedJobStep.name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedJobStep.status = JobStatus.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobStep.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobStep.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedJobStep.message = reader.getString();
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedJobStep.statistics = JobStepStatisticsBase.fromJson(reader);
                    continue;
                }
                if ("steps".equals(fieldName)) {
                    List steps;
                    deserializedJobStep.steps = steps = reader.readArray(reader1 -> JobStep.fromJson(reader1));
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    deserializedJobStep.errorDetails = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobStep;
        });
    }
}

