/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ActiveState;
import com.azure.resourcemanager.workloadorchestration.models.DeploymentStatus;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import com.azure.resourcemanager.workloadorchestration.models.ReconciliationPolicyProperties;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersionSnapshot;
import com.azure.resourcemanager.workloadorchestration.models.TargetSnapshot;
import java.io.IOException;

public final class InstanceHistoryProperties
implements JsonSerializable<InstanceHistoryProperties> {
    private SolutionVersionSnapshot solutionVersion;
    private TargetSnapshot target;
    private String solutionScope;
    private ActiveState activeState;
    private ReconciliationPolicyProperties reconciliationPolicy;
    private DeploymentStatus status;
    private ProvisioningState provisioningState;

    private InstanceHistoryProperties() {
    }

    public SolutionVersionSnapshot solutionVersion() {
        return this.solutionVersion;
    }

    public TargetSnapshot target() {
        return this.target;
    }

    public String solutionScope() {
        return this.solutionScope;
    }

    public ActiveState activeState() {
        return this.activeState;
    }

    public ReconciliationPolicyProperties reconciliationPolicy() {
        return this.reconciliationPolicy;
    }

    public DeploymentStatus status() {
        return this.status;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.solutionVersion() != null) {
            this.solutionVersion().validate();
        }
        if (this.target() != null) {
            this.target().validate();
        }
        if (this.reconciliationPolicy() != null) {
            this.reconciliationPolicy().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("activeState", this.activeState == null ? null : this.activeState.toString());
        return jsonWriter.writeEndObject();
    }

    public static InstanceHistoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InstanceHistoryProperties)jsonReader.readObject(reader -> {
            InstanceHistoryProperties deserializedInstanceHistoryProperties = new InstanceHistoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("solutionVersion".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.solutionVersion = SolutionVersionSnapshot.fromJson(reader);
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.target = TargetSnapshot.fromJson(reader);
                    continue;
                }
                if ("solutionScope".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.solutionScope = reader.getString();
                    continue;
                }
                if ("activeState".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.activeState = ActiveState.fromString(reader.getString());
                    continue;
                }
                if ("reconciliationPolicy".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.reconciliationPolicy = ReconciliationPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.status = DeploymentStatus.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedInstanceHistoryProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstanceHistoryProperties;
        });
    }
}

