/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocationType;
import java.io.IOException;

public final class ExtendedLocation
implements JsonSerializable<ExtendedLocation> {
    private String name;
    private ExtendedLocationType type;
    private static final ClientLogger LOGGER = new ClientLogger(ExtendedLocation.class);

    public String name() {
        return this.name;
    }

    public ExtendedLocation withName(String name) {
        this.name = name;
        return this;
    }

    public ExtendedLocationType type() {
        return this.type;
    }

    public ExtendedLocation withType(ExtendedLocationType type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExtendedLocation"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ExtendedLocation"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ExtendedLocation fromJson(JsonReader jsonReader) throws IOException {
        return (ExtendedLocation)jsonReader.readObject(reader -> {
            ExtendedLocation deserializedExtendedLocation = new ExtendedLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExtendedLocation.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExtendedLocation.type = ExtendedLocationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtendedLocation;
        });
    }
}

