/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ExecutionStatus;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class ExecutionProperties
implements JsonSerializable<ExecutionProperties> {
    private String workflowVersionId;
    private Map<String, BinaryData> specification;
    private ExecutionStatus status;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionProperties.class);

    public String workflowVersionId() {
        return this.workflowVersionId;
    }

    public ExecutionProperties withWorkflowVersionId(String workflowVersionId) {
        this.workflowVersionId = workflowVersionId;
        return this;
    }

    public Map<String, BinaryData> specification() {
        return this.specification;
    }

    public ExecutionProperties withSpecification(Map<String, BinaryData> specification) {
        this.specification = specification;
        return this;
    }

    public ExecutionStatus status() {
        return this.status;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.workflowVersionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property workflowVersionId in model ExecutionProperties"));
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workflowVersionId", this.workflowVersionId);
        jsonWriter.writeMapField("specification", this.specification, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        return jsonWriter.writeEndObject();
    }

    public static ExecutionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionProperties)jsonReader.readObject(reader -> {
            ExecutionProperties deserializedExecutionProperties = new ExecutionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("workflowVersionId".equals(fieldName)) {
                    deserializedExecutionProperties.workflowVersionId = reader.getString();
                    continue;
                }
                if ("specification".equals(fieldName)) {
                    Map specification;
                    deserializedExecutionProperties.specification = specification = reader.readMap(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedExecutionProperties.status = ExecutionStatus.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExecutionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionProperties;
        });
    }
}

