/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.JobStepStatisticsBase;
import com.azure.resourcemanager.workloadorchestration.models.JobType;
import java.io.IOException;

public final class DeployJobStepStatistics
extends JobStepStatisticsBase {
    private JobType statisticsType = JobType.DEPLOY;
    private Integer totalCount;
    private Integer successCount;
    private Integer failedCount;

    private DeployJobStepStatistics() {
    }

    @Override
    public JobType statisticsType() {
        return this.statisticsType;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Integer successCount() {
        return this.successCount;
    }

    public Integer failedCount() {
        return this.failedCount;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("statisticsType", this.statisticsType == null ? null : this.statisticsType.toString());
        jsonWriter.writeNumberField("totalCount", (Number)this.totalCount);
        jsonWriter.writeNumberField("successCount", (Number)this.successCount);
        jsonWriter.writeNumberField("failedCount", (Number)this.failedCount);
        return jsonWriter.writeEndObject();
    }

    public static DeployJobStepStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (DeployJobStepStatistics)jsonReader.readObject(reader -> {
            DeployJobStepStatistics deserializedDeployJobStepStatistics = new DeployJobStepStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("statisticsType".equals(fieldName)) {
                    deserializedDeployJobStepStatistics.statisticsType = JobType.fromString(reader.getString());
                    continue;
                }
                if ("totalCount".equals(fieldName)) {
                    deserializedDeployJobStepStatistics.totalCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("successCount".equals(fieldName)) {
                    deserializedDeployJobStepStatistics.successCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("failedCount".equals(fieldName)) {
                    deserializedDeployJobStepStatistics.failedCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeployJobStepStatistics;
        });
    }
}

