/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.InstallSolutionParameter;
import com.azure.resourcemanager.workloadorchestration.models.JobParameterBase;
import com.azure.resourcemanager.workloadorchestration.models.JobType;
import java.io.IOException;

public final class DeployJobParameter
extends JobParameterBase {
    private JobType jobType = JobType.DEPLOY;
    private InstallSolutionParameter parameter;

    private DeployJobParameter() {
    }

    @Override
    public JobType jobType() {
        return this.jobType;
    }

    public InstallSolutionParameter parameter() {
        return this.parameter;
    }

    @Override
    public void validate() {
        if (this.parameter() != null) {
            this.parameter().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobType", this.jobType == null ? null : this.jobType.toString());
        jsonWriter.writeJsonField("parameter", (JsonSerializable)this.parameter);
        return jsonWriter.writeEndObject();
    }

    public static DeployJobParameter fromJson(JsonReader jsonReader) throws IOException {
        return (DeployJobParameter)jsonReader.readObject(reader -> {
            DeployJobParameter deserializedDeployJobParameter = new DeployJobParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobType".equals(fieldName)) {
                    deserializedDeployJobParameter.jobType = JobType.fromString(reader.getString());
                    continue;
                }
                if ("parameter".equals(fieldName)) {
                    deserializedDeployJobParameter.parameter = InstallSolutionParameter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeployJobParameter;
        });
    }
}

