/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.Capability;
import com.azure.resourcemanager.workloadorchestration.models.Hierarchy;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ContextProperties
implements JsonSerializable<ContextProperties> {
    private List<Capability> capabilities;
    private List<Hierarchy> hierarchies;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ContextProperties.class);

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public ContextProperties withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<Hierarchy> hierarchies() {
        return this.hierarchies;
    }

    public ContextProperties withHierarchies(List<Hierarchy> hierarchies) {
        this.hierarchies = hierarchies;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.capabilities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property capabilities in model ContextProperties"));
        }
        this.capabilities().forEach(e -> e.validate());
        if (this.hierarchies() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hierarchies in model ContextProperties"));
        }
        this.hierarchies().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("hierarchies", this.hierarchies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ContextProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ContextProperties)jsonReader.readObject(reader -> {
            ContextProperties deserializedContextProperties = new ContextProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedContextProperties.capabilities = capabilities = reader.readArray(reader1 -> Capability.fromJson(reader1));
                    continue;
                }
                if ("hierarchies".equals(fieldName)) {
                    List hierarchies;
                    deserializedContextProperties.hierarchies = hierarchies = reader.readArray(reader1 -> Hierarchy.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedContextProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContextProperties;
        });
    }
}

