/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ProvisioningState;
import java.io.IOException;

public final class ConfigTemplateProperties
implements JsonSerializable<ConfigTemplateProperties> {
    private String description;
    private String latestVersion;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ConfigTemplateProperties.class);

    public String description() {
        return this.description;
    }

    public ConfigTemplateProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String latestVersion() {
        return this.latestVersion;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model ConfigTemplateProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ConfigTemplateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigTemplateProperties)jsonReader.readObject(reader -> {
            ConfigTemplateProperties deserializedConfigTemplateProperties = new ConfigTemplateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedConfigTemplateProperties.description = reader.getString();
                    continue;
                }
                if ("latestVersion".equals(fieldName)) {
                    deserializedConfigTemplateProperties.latestVersion = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedConfigTemplateProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigTemplateProperties;
        });
    }
}

