/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.BulkPublishTargetDetails;
import com.azure.resourcemanager.workloadorchestration.models.SolutionDependencyParameter;
import java.io.IOException;
import java.util.List;

public final class BulkPublishSolutionParameter
implements JsonSerializable<BulkPublishSolutionParameter> {
    private List<BulkPublishTargetDetails> targets;
    private String solutionInstanceName;
    private List<SolutionDependencyParameter> solutionDependencies;
    private static final ClientLogger LOGGER = new ClientLogger(BulkPublishSolutionParameter.class);

    public List<BulkPublishTargetDetails> targets() {
        return this.targets;
    }

    public BulkPublishSolutionParameter withTargets(List<BulkPublishTargetDetails> targets) {
        this.targets = targets;
        return this;
    }

    public String solutionInstanceName() {
        return this.solutionInstanceName;
    }

    public BulkPublishSolutionParameter withSolutionInstanceName(String solutionInstanceName) {
        this.solutionInstanceName = solutionInstanceName;
        return this;
    }

    public List<SolutionDependencyParameter> solutionDependencies() {
        return this.solutionDependencies;
    }

    public BulkPublishSolutionParameter withSolutionDependencies(List<SolutionDependencyParameter> solutionDependencies) {
        this.solutionDependencies = solutionDependencies;
        return this;
    }

    public void validate() {
        if (this.targets() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targets in model BulkPublishSolutionParameter"));
        }
        this.targets().forEach(e -> e.validate());
        if (this.solutionDependencies() != null) {
            this.solutionDependencies().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("solutionInstanceName", this.solutionInstanceName);
        jsonWriter.writeArrayField("solutionDependencies", this.solutionDependencies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BulkPublishSolutionParameter fromJson(JsonReader jsonReader) throws IOException {
        return (BulkPublishSolutionParameter)jsonReader.readObject(reader -> {
            BulkPublishSolutionParameter deserializedBulkPublishSolutionParameter = new BulkPublishSolutionParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedBulkPublishSolutionParameter.targets = targets = reader.readArray(reader1 -> BulkPublishTargetDetails.fromJson(reader1));
                    continue;
                }
                if ("solutionInstanceName".equals(fieldName)) {
                    deserializedBulkPublishSolutionParameter.solutionInstanceName = reader.getString();
                    continue;
                }
                if ("solutionDependencies".equals(fieldName)) {
                    List solutionDependencies;
                    deserializedBulkPublishSolutionParameter.solutionDependencies = solutionDependencies = reader.readArray(reader1 -> SolutionDependencyParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBulkPublishSolutionParameter;
        });
    }
}

