/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.fluent.models.WorkflowVersionInner;
import java.io.IOException;
import java.util.List;

public final class WorkflowVersionListResult
implements JsonSerializable<WorkflowVersionListResult> {
    private List<WorkflowVersionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(WorkflowVersionListResult.class);

    private WorkflowVersionListResult() {
    }

    public List<WorkflowVersionInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model WorkflowVersionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowVersionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowVersionListResult)jsonReader.readObject(reader -> {
            WorkflowVersionListResult deserializedWorkflowVersionListResult = new WorkflowVersionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedWorkflowVersionListResult.value = value = reader.readArray(reader1 -> WorkflowVersionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedWorkflowVersionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowVersionListResult;
        });
    }
}

